/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.GunCommonUtil;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class GunShootTargetTask
extends class_4097<EntityMaid> {
    private int attackCooldown = -1;
    private int seeTime;

    public GunShootTargetTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_22355, (Object)class_4141.field_18456), 1200);
    }

    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        if (!GunCommonUtil.isGun(owner.method_6047())) {
            return false;
        }
        return owner.method_18868().method_18904(class_4140.field_22355).filter(owner::canSee).isPresent();
    }

    protected boolean canStillUse(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        return entityIn.method_18868().method_18896(class_4140.field_22355) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    protected void start(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    protected void tick(class_3218 worldIn, EntityMaid owner, long gameTime) {
        owner.method_18868().method_18904(class_4140.field_22355).ifPresent(target -> {
            boolean seeTimeMoreThanZero;
            owner.method_5988().method_20248(target.method_23317(), target.method_23318(), target.method_23321());
            boolean canSee = owner.canSee((class_1309)target);
            boolean bl = seeTimeMoreThanZero = this.seeTime > 0;
            if (canSee != seeTimeMoreThanZero) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            class_1799 mainHandItem = owner.method_6047();
            GunCommonUtil.tick(owner, target, mainHandItem);
            if (--this.attackCooldown <= 0 && this.seeTime >= -60 && canSee) {
                try {
                    this.attackCooldown = GunCommonUtil.performGunAttack(owner, target, mainHandItem);
                }
                catch (Exception e) {
                    TouhouLittleMaid.LOGGER.error("Error while performing gun attack for EntityMaid: {}", (Object)owner.method_5667(), (Object)e);
                    this.attackCooldown = 100;
                }
            }
        });
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    protected void stop(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        this.seeTime = 0;
        this.attackCooldown = -1;
        maid.setSwingingArms(false);
        maid.setAiming(false);
        GunCommonUtil.onStop(maid, this);
    }
}

