/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datapack;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManager;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.TextChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_2561;
import net.minecraft.class_4168;
import net.minecraft.class_5250;

public class KaomojiData {
    private static final Map<String, List<String>> KAOMOJI_MAP = Maps.newHashMap();
    private static final String CORE = "core";
    private static final String WORK = "work";
    private static final String IDLE = "idle";
    private static final String SLEEP = "sleep";
    private static final String HURT = "hurt";
    private static final Random RANDOM = new Random();

    public static void clear() {
        KAOMOJI_MAP.clear();
    }

    public static void merge(Map<String, List<String>> data) {
        List<String> core = data.get(CORE);
        if (core != null) {
            if (data.containsKey(WORK)) {
                data.get(WORK).addAll(core);
            }
            if (data.containsKey(IDLE)) {
                data.get(IDLE).addAll(core);
            }
            data.remove(CORE);
        }
        data.keySet().forEach(key -> {
            List value = (List)data.get(key);
            KAOMOJI_MAP.computeIfAbsent((String)key, k -> Lists.newArrayList()).addAll(value);
        });
    }

    public static void showRoutineKaomoji(EntityMaid maid, ChatBubbleManager bubbleManager) {
        class_4168 activity = maid.getScheduleDetail();
        if (activity == class_4168.field_18597) {
            String randomEmoji = KaomojiData.getRandomEmoji(KAOMOJI_MAP.get(SLEEP));
            class_5250 literal = class_2561.method_43470((String)randomEmoji);
            bubbleManager.addChatBubble(TextChatBubbleData.type2((class_2561)literal));
            return;
        }
        if (activity == class_4168.field_18595 || maid.getTask() == TaskManager.getIdleTask()) {
            String randomEmoji = KaomojiData.getRandomEmoji(KAOMOJI_MAP.get(IDLE));
            class_5250 literal = class_2561.method_43470((String)randomEmoji);
            bubbleManager.addChatBubble(TextChatBubbleData.type2((class_2561)literal));
            return;
        }
        if (activity == class_4168.field_18596) {
            String randomEmoji = KaomojiData.getRandomEmoji(KAOMOJI_MAP.get(WORK));
            class_5250 literal = class_2561.method_43470((String)randomEmoji);
            bubbleManager.addChatBubble(TextChatBubbleData.type2((class_2561)literal));
        }
    }

    public static void showHurtKaomoji(EntityMaid maid, ChatBubbleManager bubbleManager) {
        String randomEmoji = KaomojiData.getRandomEmoji(KAOMOJI_MAP.get(HURT));
        class_5250 literal = class_2561.method_43470((String)randomEmoji);
        bubbleManager.addChatBubble(TextChatBubbleData.type2((class_2561)literal));
    }

    private static String getRandomEmoji(List<String> emojis) {
        if (emojis == null || emojis.isEmpty()) {
            return "";
        }
        int index = RANDOM.nextInt(emojis.size());
        return emojis.get(index);
    }
}

