/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.CombinedInvWrapper;
import com.github.tartaricacid.touhoulittlemaid.api.task.IFeedTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class MaidFeedOwnerTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 20;
    private final IFeedTask task;
    private final float walkSpeed;
    private final int closeEnoughDist;

    public MaidFeedOwnerTask(IFeedTask task, int closeEnoughDist, float walkSpeed) {
        super((Map<class_4140<?>, class_4141>)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457));
        this.task = task;
        this.walkSpeed = walkSpeed;
        this.closeEnoughDist = closeEnoughDist;
        this.setMaxCheckRate(20);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid maid) {
        if (super.checkExtraStartConditions(worldIn, maid)) {
            class_1309 owner = maid.method_35057();
            if (owner instanceof class_1657 && owner.method_5805() && maid.method_18407(owner.method_24515())) {
                if (owner.method_24516((class_1297)maid, (double)this.closeEnoughDist)) {
                    return true;
                }
                class_4215.method_24557((class_1309)maid, (class_1297)owner, (float)this.walkSpeed, (int)1);
            }
            return false;
        }
        return false;
    }

    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        class_1309 owner = maid.method_35057();
        if (owner instanceof class_1657) {
            class_1657 player = (class_1657)owner;
            if (owner.method_5805()) {
                boolean dying = player.method_6032() / player.method_6063() < 0.5f;
                IntArrayList lowestFoods = new IntArrayList();
                IntArrayList lowFoods = new IntArrayList();
                IntArrayList highFoods = new IntArrayList();
                CombinedInvWrapper inv = maid.getAvailableInv(true);
                for (int i = 0; i < inv.getSlots(); ++i) {
                    class_1799 stack = inv.getStackInSlot(i);
                    if (!this.task.isFood(stack, player)) continue;
                    IFeedTask.Priority priority = this.task.getPriority(stack, player);
                    if (priority == IFeedTask.Priority.HIGH) {
                        highFoods.add(i);
                        break;
                    }
                    if (priority == IFeedTask.Priority.LOW) {
                        lowFoods.add(i);
                        break;
                    }
                    if (!dying || priority != IFeedTask.Priority.LOWEST) continue;
                    lowestFoods.add(i);
                    break;
                }
                if (highFoods.isEmpty() && lowFoods.isEmpty() && lowestFoods.isEmpty()) {
                    return;
                }
                IntArrayList map = !highFoods.isEmpty() ? highFoods : (!lowFoods.isEmpty() ? lowFoods : lowestFoods);
                map.intStream().skip(maid.method_59922().method_43048(map.size())).findFirst().ifPresent(slot -> {
                    inv.setStackInSlot(slot, this.task.feed(inv.getStackInSlot(slot), player));
                    maid.method_6104(class_1268.field_5808);
                    this.setNextCheckTickCount(5);
                    class_1309 patt0$temp = maid.method_35057();
                    if (patt0$temp instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)patt0$temp;
                        InitTrigger.MAID_EVENT.trigger(serverPlayer, "maid_feed_player");
                    }
                });
            }
        }
    }
}

