/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.INodeCacheEvaluator;
import java.util.Arrays;
import net.minecraft.class_2338;
import net.minecraft.class_7;
import net.minecraft.class_9;

public class NodeNeighborCache {
    public final int tickCount;
    private final int centerX;
    private final int centerY;
    private final int centerZ;
    private final int dx;
    private final int dy;
    private final int dz;
    private final int rx;
    private final int ry;
    private final int rz;
    private final int[] nextOffset;
    private final long[] data;
    private final long[] data2;
    private final float[] data3;
    private final int[] start;
    private int nextFree = 1;

    public NodeNeighborCache(int x, int y, int z, int rx, int ry, int rz, int tickCount) {
        this.centerX = x;
        this.centerY = y;
        this.centerZ = z;
        this.dx = rx * 2 + 1;
        this.dy = ry * 2 + 1;
        this.dz = rz * 2 + 1;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        this.nextOffset = new int[this.dx * this.dy * this.dz * 10];
        this.start = new int[this.dx * this.dy * this.dz];
        this.data = new long[this.dx * this.dy * this.dz * 10];
        this.data2 = new long[this.dx * this.dy * this.dz * 10];
        this.data3 = new float[this.dx * this.dy * this.dz * 10];
        this.nextOffset[this.dx * this.dy * this.dz - 1] = 0;
        this.tickCount = tickCount;
    }

    private NodeNeighborCache(int x, int y, int z, NodeNeighborCache cache) {
        this.centerX = x;
        this.centerY = y;
        this.centerZ = z;
        this.dx = cache.dx;
        this.dz = cache.dz;
        this.dy = cache.dy;
        this.rx = cache.rx;
        this.ry = cache.ry;
        this.rz = cache.rz;
        this.nextOffset = Arrays.copyOf(cache.nextOffset, cache.nextOffset.length);
        this.start = new int[cache.start.length];
        this.data = Arrays.copyOf(cache.data, cache.data.length);
        this.data2 = Arrays.copyOf(cache.data2, cache.data2.length);
        this.data3 = Arrays.copyOf(cache.data3, cache.data3.length);
        this.nextFree = cache.nextFree;
        this.tickCount = cache.tickCount;
    }

    public void record(class_9 pos, class_9[] nodes, int nodeId) {
        if (!this.isInRange(pos.field_40, pos.field_39, pos.field_38)) {
            return;
        }
        int nid = this.id(pos.field_40, pos.field_39, pos.field_38);
        if (!this.grantNode(nodeId)) {
            return;
        }
        int lastNode = 0;
        for (int i = 0; i < nodeId; ++i) {
            int nextFreeNode = this.getNextFreeNode();
            if (lastNode != 0) {
                this.next(lastNode, nextFreeNode);
            } else {
                this.start[nid] = nextFreeNode;
            }
            this.storeNode(nextFreeNode, nodes[i]);
            lastNode = nextFreeNode;
        }
        if (lastNode != 0) {
            this.next(lastNode, 0);
        }
    }

    private void storeNode(int i, class_9 node) {
        this.data[i - 1] = (long)node.field_40 << 32 | (long)node.field_38;
        this.data2[i - 1] = (long)node.field_39 << 32 | (long)(node.field_41.ordinal() << 1) | (long)(node.field_42 ? 1 : 0);
        this.data3[i - 1] = node.field_43;
    }

    private class_9 addNode(int i, INodeCacheEvaluator nodeCreator) {
        class_9 node = nodeCreator.createNode((int)(this.data[i - 1] >> 32), (int)(this.data2[i - 1] >> 32), (int)(this.data[i - 1] & 0xFFFFFFFFL));
        node.field_41 = class_7.values()[(int)(this.data2[i - 1] & 0xFFFFFFFFL) >> 1];
        node.field_43 = this.data3[i - 1] == -1.0f ? -1.0f : Math.max(node.field_43, this.data3[i - 1]);
        return node;
    }

    public int get(class_9 node, class_9[] nodes, INodeCacheEvaluator nodeCreator) {
        if (!this.isInRange(node.field_40, node.field_39, node.field_38)) {
            return -1;
        }
        int nid = this.id(node.field_40, node.field_39, node.field_38);
        if (this.start[nid] == 0) {
            return -1;
        }
        int i = this.start[nid];
        int count = 0;
        while (i != 0) {
            nodes[count++] = this.addNode(i, nodeCreator);
            i = this.next(i);
        }
        return count;
    }

    public boolean grantNode(int count) {
        int t = this.nextFree;
        for (int i = 0; i < count; ++i) {
            if (t == 0) {
                return false;
            }
            t = this.next(t);
        }
        return true;
    }

    public int getNextFreeNode() {
        int tmp = this.nextFree;
        this.nextFree = this.next(this.nextFree);
        return tmp;
    }

    public void clearForId(int nid) {
        if (this.start[nid] == 0) {
            return;
        }
        this.next(this.finalFrom(this.start[nid]), this.nextFree);
        this.nextFree = this.start[nid];
        this.start[nid] = 0;
    }

    public int id(class_2338 pos) {
        return this.id(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public int id(int x, int y, int z) {
        return (x - this.centerX + this.rx) * this.dy * this.dz + (y - this.centerY + this.ry) * this.dz + (z - this.centerZ + this.rz);
    }

    public int next(int id) {
        return id + this.nextOffset[id - 1] + 1;
    }

    public void next(int id, int i) {
        this.nextOffset[id - 1] = i - id - 1;
    }

    public int finalFrom(int id) {
        int i = id;
        while (this.next(i) != 0) {
            i = this.next(i);
        }
        return i;
    }

    public boolean isInRange(int ix, int iy, int iz) {
        return ix >= this.centerX - this.rx && ix <= this.centerX + this.rx && iy >= this.centerY - this.ry && iy <= this.centerY + this.ry && iz >= this.centerZ - this.rz && iz <= this.centerZ + this.rz;
    }

    public static NodeNeighborCache copyToAnotherCenter(NodeNeighborCache cache, int x, int y, int z) {
        NodeNeighborCache t = new NodeNeighborCache(x, y, z, cache);
        for (int tx = cache.centerX - cache.rx; tx <= cache.centerX + cache.rx; ++tx) {
            for (int ty = cache.centerY - cache.ry; ty <= cache.centerY + cache.ry; ++ty) {
                for (int tz = cache.centerZ - cache.rz; tz <= cache.centerZ + cache.rz; ++tz) {
                    if (t.isInRange(tx, ty, tz)) {
                        t.start[t.id((int)tx, (int)ty, (int)tz)] = cache.start[cache.id(tx, ty, tz)];
                        continue;
                    }
                    t.clearForId(cache.id(tx, ty, tz));
                }
            }
        }
        return t;
    }
}

