/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IBroomControl;
import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.entity.item.control.BroomControlManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenPlayerInventoryPackage;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_5134;
import net.minecraft.class_6025;
import net.minecraft.class_7248;
import net.minecraft.class_8710;

public class EntityBroom
extends AbstractEntityFromItem
implements class_6025,
class_7248 {
    public static final class_1299<EntityBroom> TYPE = class_1299.class_1300.method_5903(EntityBroom::new, (class_1311)class_1311.field_17715).method_17687(1.375f, 0.5625f).method_27299(10).method_55691(0.0f).method_5905("broom");
    private static final class_2940<Optional<UUID>> OWNER_ID = class_2945.method_12791(EntityBroom.class, (class_2941)class_2943.field_13313);
    private final List<IBroomControl> broomControls;
    public boolean inPhysicalCheck = false;
    private class_238 physicalBoundingBox = new class_238(class_243.field_1353, class_243.field_1353);

    public EntityBroom(class_1299<EntityBroom> entityType, class_1937 worldIn) {
        super(entityType, worldIn);
        this.method_5875(true);
        this.broomControls = BroomControlManager.onBroomInit(this);
    }

    public EntityBroom(class_1937 worldIn) {
        this(TYPE, worldIn);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(OWNER_ID, Optional.empty());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("owner_uuid")) {
            this.setOwnerUUID(class_2512.method_25930((class_2520)Objects.requireNonNull(compound.method_10580("owner_uuid"))));
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        ((Optional)this.field_6011.method_12789(OWNER_ID)).ifPresent(uuid -> compound.method_25927("owner_uuid", uuid));
    }

    protected class_238 method_33332() {
        class_238 aabb = super.method_33332();
        this.physicalBoundingBox = this.method_5685().size() > 1 ? new class_238(aabb.field_1323, aabb.field_1322, aabb.field_1321, aabb.field_1320, aabb.field_1325 + 1.0, aabb.field_1324) : aabb;
        return aabb;
    }

    public void method_6091(class_243 vec3) {
        class_1297 secondPassenger;
        class_1309 entity = this.method_5642();
        class_1297 class_12972 = secondPassenger = this.method_5685().size() >= 2 ? (class_1297)this.method_5685().get(1) : null;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (secondPassenger instanceof EntityMaid) {
                EntityMaid maid = (EntityMaid)secondPassenger;
                for (IBroomControl broomControl : this.broomControls) {
                    if (!broomControl.inControl(player, maid)) continue;
                    broomControl.travel(player, maid);
                    break;
                }
                this.method_5784(class_1313.field_6308, this.method_18798());
                return;
            }
        }
        if (!this.method_24828()) {
            super.method_6091(new class_243(0.0, (double)-0.3f, 0.0));
            return;
        }
        super.method_6091(vec3);
    }

    public float method_49485(class_1657 player) {
        return (float)player.method_45325(class_5134.field_23719);
    }

    protected void method_6070() {
        if (this.method_5685().size() >= 2) {
            return;
        }
        if (!this.method_5685().isEmpty() && !(this.method_5642() instanceof class_1657)) {
            return;
        }
        if (!this.field_6002.field_9236) {
            List list = this.field_6002.method_8390(EntityMaid.class, this.method_5829().method_1012(0.5, 0.1, 0.5), this::canMaidRide);
            list.stream().findFirst().ifPresent(entity -> entity.method_5804((class_1297)this));
        }
    }

    private boolean canMaidRide(EntityMaid maid) {
        if (maid.canBrainMoving() && !maid.method_5782() && class_1301.method_5911((class_1297)this).test(maid)) {
            UUID maidOwnerUUID = maid.method_6139();
            UUID broomOwnerUUID = this.method_6139();
            if (maidOwnerUUID == null || broomOwnerUUID == null) {
                return false;
            }
            return maidOwnerUUID.equals(broomOwnerUUID);
        }
        return false;
    }

    protected void method_49481(class_1657 player, class_243 travelVector) {
        class_1297 secondPassenger;
        this.field_6017 = 0.0f;
        if (!this.method_24828()) {
            this.method_45319(new class_243(0.0, 0.003 * Math.sin((double)this.field_6012 * Math.PI / 18.0), 0.0));
        }
        class_1297 class_12972 = secondPassenger = this.method_5685().size() >= 2 ? (class_1297)this.method_5685().get(1) : null;
        if (secondPassenger instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)secondPassenger;
            for (IBroomControl broomControl : this.broomControls) {
                if (!broomControl.inControl(player, maid)) continue;
                broomControl.tickRot(player, maid);
                break;
            }
        } else {
            this.field_6283 = this.field_6241 = this.method_36454();
            this.field_5982 = this.field_6241;
            this.method_5710(player.method_36454(), player.method_36455());
        }
        super.method_49481(player, travelVector);
    }

    public void method_5710(float pYRot, float pXRot) {
        super.method_5710(pYRot, pXRot);
    }

    protected class_243 method_52533(class_1297 passenger, class_4048 dimension, float partialTick) {
        double xOffset;
        double d = xOffset = passenger instanceof EntityMaid ? -0.5 : 0.0;
        if (this.method_5685().size() > 1) {
            xOffset = this.method_5685().indexOf(passenger) == 0 ? 0.35 : -0.35;
        }
        class_243 hOffset = new class_243(xOffset, -0.3125, 0.0).method_1024((float)((double)(-(this.method_36454() + 90.0f)) * Math.PI / 180.0));
        return super.method_52533(passenger, dimension, partialTick).method_1019(hOffset);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!(player.method_21751() || this.method_5765() || this.method_5642() instanceof class_1657)) {
            if (this.method_5685().size() > 1) {
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            if (!this.field_6002.field_9236) {
                player.method_5804((class_1297)this);
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        return super.method_5688(player, hand);
    }

    @Nullable
    public class_1309 method_5642() {
        class_1297 entity = this.method_31483();
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return player;
        }
        return null;
    }

    public void method_6722(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        List passengers = this.method_5685();
        boolean hasPlayer = false;
        EntityMaid maidOpen = null;
        for (int i = 0; i < Math.min(passengers.size(), 2); ++i) {
            EntityMaid maid;
            class_1297 entity = (class_1297)passengers.get(i);
            if (entity.equals((Object)player)) {
                hasPlayer = true;
            }
            if (!(entity instanceof EntityMaid) || !(maid = (EntityMaid)entity).method_6171((class_1309)player)) continue;
            maidOpen = maid;
        }
        if (hasPlayer) {
            if (maidOpen == null) {
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new OpenPlayerInventoryPackage(0));
            } else {
                maidOpen.openMaidGui((class_1657)serverPlayer);
            }
        }
    }

    public boolean method_30948() {
        return this.method_5805();
    }

    protected boolean method_5818(class_1297 entity) {
        return this.method_5685().size() < 2;
    }

    @Override
    protected boolean canKillEntity(class_1657 player) {
        return true;
    }

    @Override
    protected class_3414 getHitSound() {
        return class_3417.field_14983;
    }

    @Override
    protected class_1792 getWithItem() {
        return InitItems.BROOM;
    }

    @Override
    protected class_1799 getKilledStack() {
        return new class_1799((class_1935)this.getWithItem());
    }

    public boolean method_5747(float pFallDistance, float pMultiplier, class_1282 pSource) {
        return false;
    }

    protected void method_5623(double pY, boolean pOnGround, class_2680 pState, class_2338 pPos) {
        this.method_38785();
    }

    @Nullable
    public UUID method_6139() {
        return ((Optional)this.field_6011.method_12789(OWNER_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.field_6011.method_12778(OWNER_ID, Optional.ofNullable(uuid));
    }

    public class_238 getPhysicalBoundingBox() {
        return this.physicalBoundingBox;
    }
}

