/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.handler;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.BaubleManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.function.BiPredicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

public class BaubleItemHandler
extends ItemStackHandler {
    private final Int2ObjectSortedMap<IMaidBauble> baubles = new Int2ObjectRBTreeMap();

    public BaubleItemHandler() {
        this(1);
    }

    public BaubleItemHandler(int size) {
        super(size);
    }

    public BaubleItemHandler(class_2371<class_1799> stacks) {
        super(stacks);
        IntStream.range(0, this.getSlots()).forEach(this::onContentsChanged);
    }

    private void setBaubleInSlot(int slot, @Nullable IMaidBauble bauble) {
        this.validateSlotIndex(slot);
        if (bauble == null) {
            this.baubles.remove(slot);
        } else {
            this.baubles.put(slot, (Object)bauble);
        }
    }

    @Nullable
    public IMaidBauble getBaubleInSlot(int slot) {
        class_1799 stack = this.getStackInSlot(slot);
        if (stack.method_7960()) {
            return null;
        }
        return (IMaidBauble)this.baubles.get(slot);
    }

    @Override
    protected void onContentsChanged(int slot) {
        class_1799 stack = this.getStackInSlot(slot);
        if (stack.method_7960()) {
            this.setBaubleInSlot(slot, null);
        } else {
            this.setBaubleInSlot(slot, BaubleManager.getBauble(stack));
        }
    }

    @Override
    public boolean isItemValid(int slot, @Nonnull class_1799 stack) {
        return BaubleManager.getBauble(stack) != null;
    }

    @Override
    @Nonnull
    public class_1799 insertItem(int slot, @Nonnull class_1799 stack, boolean simulate) {
        if (this.isItemValid(slot, stack)) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @Override
    protected void onLoad() {
        IntStream.range(0, this.getSlots()).forEach(this::onContentsChanged);
    }

    public boolean fireEvent(BiPredicate<IMaidBauble, class_1799> function) {
        ObjectBidirectionalIterator iterator = this.baubles.int2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            int slot = entry.getIntKey();
            IMaidBauble bauble = (IMaidBauble)entry.getValue();
            class_1799 stack = this.getStackInSlot(slot);
            if (stack.method_7960()) {
                iterator.remove();
                continue;
            }
            if (!function.test(bauble, stack)) continue;
            return true;
        }
        return false;
    }

    public int getBaubleSlot(IMaidBauble bauble) {
        for (Int2ObjectMap.Entry entry : this.baubles.int2ObjectEntrySet()) {
            if (entry.getValue() != bauble) continue;
            return entry.getIntKey();
        }
        return -1;
    }

    @Override
    public void readFromNbt(class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 provider) {
        if (tag.method_10545("Inventory")) {
            int oldSize;
            class_2487 baubleTag = tag.method_10562("Inventory");
            if (baubleTag.method_10573("Size", 3) && (oldSize = baubleTag.method_10550("Size")) < 30) {
                baubleTag.method_10569("Size", 30);
            }
            this.deserializeNBT(provider, tag.method_10562("Inventory"));
        }
    }
}

