/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.BoardStateTooltip;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5632;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.StringUtils;

public class ItemBoardState
extends class_1792 {
    public static final String DATA_TAG = "BoardStateData";
    public static final String DESC_TAG = "BoardStateDesc";
    public static final String AUTHOR_TAG = "BoardStateAuthor";

    public ItemBoardState() {
        super(new class_1792.class_1793());
    }

    public static void setState(class_1799 stack, String data, String desc, String author) {
        BoardStateInfo info = new BoardStateInfo(data, desc, author);
        stack.method_57379(InitDataComponent.BOARD_STATE_TAG, (Object)info);
    }

    @Nullable
    public static String[] getState(class_1799 stack) {
        BoardStateInfo info = (BoardStateInfo)stack.method_57824(InitDataComponent.BOARD_STATE_TAG);
        if (info == null) {
            return null;
        }
        return new String[]{info.data(), info.description(), info.author()};
    }

    @Environment(value=EnvType.CLIENT)
    public Optional<class_5632> method_32346(class_1799 stack) {
        if (!class_437.method_25442()) {
            return Optional.empty();
        }
        String[] state = ItemBoardState.getState(stack);
        if (state == null) {
            return Optional.empty();
        }
        String stateData = state[0];
        if (StringUtils.isBlank((CharSequence)stateData)) {
            return Optional.empty();
        }
        if (stack.method_31574(InitItems.GOMOKU_BOARD_STATE)) {
            return Optional.of(BoardStateTooltip.ofGomoku(stateData));
        }
        if (stack.method_31574(InitItems.CCHESS_BOARD_STATE)) {
            return Optional.of(BoardStateTooltip.ofXiangqi(stateData));
        }
        if (stack.method_31574(InitItems.WCHESS_BOARD_STATE)) {
            return Optional.of(BoardStateTooltip.ofChess(stateData));
        }
        return Optional.empty();
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 tooltipFlag) {
        String author;
        String[] state = ItemBoardState.getState(stack);
        if (state == null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltips.touhou_little_maid.board_state.empty").method_27692(class_124.field_1080));
            return;
        }
        String descKey = state[1];
        if (StringUtils.isNotBlank((CharSequence)descKey)) {
            tooltip.add((class_2561)class_2561.method_43471((String)descKey).method_27692(class_124.field_1080));
        }
        if (StringUtils.isNotBlank((CharSequence)(author = state[2]))) {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltips.touhou_little_maid.board_state.author", (Object[])new Object[]{author}).method_27692(class_124.field_1080));
        }
        if (!class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"board_state.touhou_little_maid.show_picture").method_27692(class_124.field_1063).method_27692(class_124.field_1056));
        }
    }

    public record BoardStateInfo(String data, String description, String author) {
        public static final Codec<BoardStateInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("data").forGetter(BoardStateInfo::data), (App)Codec.STRING.fieldOf("description").forGetter(BoardStateInfo::description), (App)Codec.STRING.fieldOf("author").forGetter(BoardStateInfo::author)).apply((Applicative)instance, BoardStateInfo::new));
        public static final class_9139<ByteBuf, BoardStateInfo> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48554, BoardStateInfo::data, (class_9139)class_9135.field_48554, BoardStateInfo::description, (class_9139)class_9135.field_48554, BoardStateInfo::author, BoardStateInfo::new);
    }
}

