/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IChestType;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.chest.ChestManager;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.other.WirelessIOContainer;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_7225;

public class ItemWirelessIO
extends class_1792
implements ExtendedScreenHandlerFactory<class_1799> {
    private static final int FILTER_LIST_SIZE = 9;
    private static final String TOOLTIPS_PREFIX = "\u00a7a\u258d \u00a77";

    public ItemWirelessIO() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public static void setMode(class_1799 stack, boolean maidToChest) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            stack.method_57379(InitDataComponent.IO_MODE, (Object)maidToChest);
        }
    }

    public static boolean isMaidToChest(class_1799 stack) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            return Objects.requireNonNullElse((Boolean)stack.method_57824(InitDataComponent.IO_MODE), false);
        }
        return false;
    }

    public static void setFilterMode(class_1799 stack, boolean isBlacklist) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            stack.method_57379(InitDataComponent.FILTER_MODE, (Object)isBlacklist);
        }
    }

    public static boolean isBlacklist(class_1799 stack) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            return Objects.requireNonNullElse((Boolean)stack.method_57824(InitDataComponent.FILTER_MODE), false);
        }
        return false;
    }

    public static ItemStackHandler getFilterList(class_7225.class_7874 provider, class_1799 stack) {
        class_2487 tag;
        WirelessIOHandler handler = new WirelessIOHandler(9);
        if (stack.method_7909() == InitItems.WIRELESS_IO && (tag = (class_2487)stack.method_57824(InitDataComponent.FILTER_LIST_TAG)) != null) {
            handler.deserializeNBT(provider, tag);
        }
        return handler;
    }

    public static void setFilterList(class_7225.class_7874 provider, class_1799 stack, ItemStackHandler itemStackHandler) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            stack.method_57379(InitDataComponent.FILTER_LIST_TAG, (Object)itemStackHandler.serializeNBT(provider));
        }
    }

    @Nullable
    public static class_2338 getBindingPos(class_1799 stack) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            return (class_2338)stack.method_57824(InitDataComponent.BINDING_POS);
        }
        return null;
    }

    public static void setBindingPos(class_1799 stack, class_2338 pos) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            stack.method_57379(InitDataComponent.BINDING_POS, (Object)pos);
        }
    }

    public static void setSlotConfig(class_1799 stack, List<Boolean> config) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            stack.method_57379(InitDataComponent.SLOT_CONFIG_TAG, config);
        }
    }

    @Nullable
    public static List<Boolean> getSlotConfig(class_1799 stack) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            return (List)stack.method_57824(InitDataComponent.SLOT_CONFIG_TAG);
        }
        return null;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 worldIn = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        class_1268 hand = context.method_20287();
        class_2586 te = worldIn.method_8321(pos);
        if (hand != class_1268.field_5808) {
            return super.method_7884(context);
        }
        if (player == null) {
            return super.method_7884(context);
        }
        for (IChestType type : ChestManager.getAllChestTypes()) {
            if (!type.isChest(te) || !type.canOpenByPlayer(te, player)) continue;
            class_1799 stack = player.method_6047();
            ItemWirelessIO.setBindingPos(stack, pos);
            return class_1269.method_29236((boolean)worldIn.field_9236);
        }
        return super.method_7884(context);
    }

    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        if (handIn == class_1268.field_5808 && playerIn instanceof class_3222) {
            playerIn.method_17355((class_3908)this);
            return class_1271.method_22427((Object)playerIn.method_6047());
        }
        return super.method_7836(worldIn, playerIn, handIn);
    }

    public void method_7851(class_1799 stack, @Nullable class_1792.class_9635 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        boolean maidToChest = ItemWirelessIO.isMaidToChest(stack);
        boolean isBlacklist = ItemWirelessIO.isBlacklist(stack);
        class_2338 pos = ItemWirelessIO.getBindingPos(stack);
        String ioModeText = maidToChest ? class_1074.method_4662((String)"tooltips.touhou_little_maid.wireless_io.io_mode.input", (Object[])new Object[0]) : class_1074.method_4662((String)"tooltips.touhou_little_maid.wireless_io.io_mode.output", (Object[])new Object[0]);
        String filterModeText = isBlacklist ? class_1074.method_4662((String)"tooltips.touhou_little_maid.wireless_io.filter_mode.blacklist", (Object[])new Object[0]) : class_1074.method_4662((String)"tooltips.touhou_little_maid.wireless_io.filter_mode.whitelist", (Object[])new Object[0]);
        String hasPos = pos != null ? class_1074.method_4662((String)"tooltips.touhou_little_maid.wireless_io.binding_pos.has", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}) : class_1074.method_4662((String)"tooltips.touhou_little_maid.wireless_io.binding_pos.none", (Object[])new Object[0]);
        tooltip.add((class_2561)class_2561.method_43470((String)(TOOLTIPS_PREFIX + ioModeText)));
        tooltip.add((class_2561)class_2561.method_43470((String)(TOOLTIPS_PREFIX + filterModeText)));
        tooltip.add((class_2561)class_2561.method_43470((String)(TOOLTIPS_PREFIX + hasPos)));
        tooltip.add((class_2561)class_2561.method_43470((String)" "));
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltips.touhou_little_maid.wireless_io.usage.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltips.touhou_little_maid.wireless_io.usage.2").method_27692(class_124.field_1080));
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"item.touhou_little_maid.wireless_io");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new WirelessIOContainer(id, inventory, player.method_6047());
    }

    public class_1799 getScreenOpeningData(class_3222 player) {
        return player.method_6047();
    }

    private static class WirelessIOHandler
    extends ItemStackHandler {
        private WirelessIOHandler(int size) {
            super(size);
        }

        @Override
        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

