/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_7995;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record SpawnParticlePackage(int entityId, Type particleType, int delayTicks) implements class_8710
{
    public static final class_8710.class_9154<SpawnParticlePackage> TYPE = new class_8710.class_9154(ResourceLocationUtil.getResourceLocation("spawn_particle"));
    public static final class_9139<ByteBuf, SpawnParticlePackage> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48550, SpawnParticlePackage::entityId, Type.STREAM_CODEC, SpawnParticlePackage::particleType, (class_9139)class_9135.field_48550, SpawnParticlePackage::delayTicks, SpawnParticlePackage::new);

    public SpawnParticlePackage(int entityId, Type particleType) {
        this(entityId, particleType, 0);
    }

    public static void handle(SpawnParticlePackage message, ClientPlayNetworking.Context context) {
        if (message.delayTicks <= 0) {
            context.client().execute(() -> SpawnParticlePackage.handleSpawnParticle(message));
        } else {
            context.client().execute(() -> CompletableFuture.runAsync(() -> SpawnParticlePackage.handleSpawnParticleDelay(message, message.delayTicks), class_156.method_18349()));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void handleSpawnParticleDelay(SpawnParticlePackage message, int delayTicks) {
        try {
            Thread.sleep((long)delayTicks * 50L);
            class_310.method_1551().method_5382(() -> SpawnParticlePackage.handleSpawnParticle(message));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void handleSpawnParticle(SpawnParticlePackage message) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_1297 e = mc.field_1687.method_8469(message.entityId);
        if (e instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)e;
            if (e.method_5805()) {
                switch (message.particleType.ordinal()) {
                    case 0: {
                        maid.spawnExplosionParticle();
                        return;
                    }
                    case 1: {
                        maid.spawnBubbleParticle();
                        return;
                    }
                    case 2: {
                        maid.spawnHeartParticle();
                        return;
                    }
                    case 3: {
                        maid.spawnRankUpParticle();
                        return;
                    }
                    case 4: {
                        maid.spawnRestoreHealthParticle(maid.method_59922().method_43048(3) + 7);
                        return;
                    }
                }
            }
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static enum Type {
        EXPLOSION,
        BUBBLE,
        HEART,
        RANK_UP,
        HEAL;

        public static final IntFunction<Type> BY_ID;
        public static final class_9139<ByteBuf, Type> STREAM_CODEC;

        static {
            BY_ID = class_7995.method_47914(Enum::ordinal, (Object[])Type.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            STREAM_CODEC = class_9135.method_56375(BY_ID, Enum::ordinal);
        }
    }
}

