/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;

public class VoxelShapeUtils {
    private static final class_243 FROM_ORIGIN = new class_243(-0.5, -0.5, -0.5);

    public static void print(double x1, double y1, double z1, double x2, double y2, double z2) {
        TouhouLittleMaid.LOGGER.info("box({}, {}, {}, {}, {}, {}),", (Object)Math.min(x1, x2), (Object)Math.min(y1, y2), (Object)Math.min(z1, z2), (Object)Math.max(x1, x2), (Object)Math.max(y1, y2), (Object)Math.max(z1, z2));
    }

    public static void printSimplified(String name, class_265 shape) {
        TouhouLittleMaid.LOGGER.info("Simplified: {}", (Object)name);
        shape.method_1097().method_1090().forEach(box -> VoxelShapeUtils.print(box.field_1323 * 16.0, box.field_1322 * 16.0, box.field_1321 * 16.0, box.field_1320 * 16.0, box.field_1325 * 16.0, box.field_1324 * 16.0));
    }

    public static class_238 rotate(class_238 box, class_2350 side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> box;
            case class_2350.field_11036 -> new class_238(box.field_1323, -box.field_1322, -box.field_1321, box.field_1320, -box.field_1325, -box.field_1324);
            case class_2350.field_11043 -> new class_238(box.field_1323, -box.field_1321, box.field_1322, box.field_1320, -box.field_1324, box.field_1325);
            case class_2350.field_11035 -> new class_238(-box.field_1323, -box.field_1321, -box.field_1322, -box.field_1320, -box.field_1324, -box.field_1325);
            case class_2350.field_11039 -> new class_238(box.field_1322, -box.field_1321, -box.field_1323, box.field_1325, -box.field_1324, -box.field_1320);
            case class_2350.field_11034 -> new class_238(-box.field_1322, -box.field_1321, box.field_1323, -box.field_1325, -box.field_1324, box.field_1320);
        };
    }

    public static class_238 rotate(class_238 box, class_2470 rotation) {
        return switch (rotation) {
            default -> throw new MatchException(null, null);
            case class_2470.field_11467 -> box;
            case class_2470.field_11463 -> new class_238(-box.field_1321, box.field_1322, box.field_1323, -box.field_1324, box.field_1325, box.field_1320);
            case class_2470.field_11464 -> new class_238(-box.field_1323, box.field_1322, -box.field_1321, -box.field_1320, box.field_1325, -box.field_1324);
            case class_2470.field_11465 -> new class_238(box.field_1321, box.field_1322, -box.field_1323, box.field_1324, box.field_1325, -box.field_1320);
        };
    }

    public static class_238 rotateHorizontal(class_238 box, class_2350 side) {
        return switch (side) {
            case class_2350.field_11043 -> VoxelShapeUtils.rotate(box, class_2470.field_11467);
            case class_2350.field_11035 -> VoxelShapeUtils.rotate(box, class_2470.field_11464);
            case class_2350.field_11039 -> VoxelShapeUtils.rotate(box, class_2470.field_11465);
            case class_2350.field_11034 -> VoxelShapeUtils.rotate(box, class_2470.field_11463);
            default -> box;
        };
    }

    public static class_265 rotate(class_265 shape, class_2350 side) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotate(box, side));
    }

    public static class_265 rotate(class_265 shape, class_2470 rotation) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotate(box, rotation));
    }

    public static class_265 rotateHorizontal(class_265 shape, class_2350 side) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotateHorizontal(box, side));
    }

    public static class_265 rotate(class_265 shape, UnaryOperator<class_238> rotateFunction) {
        ArrayList<class_265> rotatedPieces = new ArrayList<class_265>();
        List sourceBoundingBoxes = shape.method_1090();
        for (class_238 sourceBoundingBox : sourceBoundingBoxes) {
            rotatedPieces.add(class_259.method_1078((class_238)((class_238)rotateFunction.apply(sourceBoundingBox.method_989(VoxelShapeUtils.FROM_ORIGIN.field_1352, VoxelShapeUtils.FROM_ORIGIN.field_1351, VoxelShapeUtils.FROM_ORIGIN.field_1350))).method_989(-VoxelShapeUtils.FROM_ORIGIN.field_1352, -VoxelShapeUtils.FROM_ORIGIN.field_1350, -VoxelShapeUtils.FROM_ORIGIN.field_1350)));
        }
        return VoxelShapeUtils.combine(rotatedPieces);
    }

    public static class_265 combine(class_265 ... shapes) {
        return VoxelShapeUtils.batchCombine(class_259.method_1073(), class_247.field_1366, true, shapes);
    }

    public static class_265 combine(Collection<class_265> shapes) {
        return VoxelShapeUtils.batchCombine(class_259.method_1073(), class_247.field_1366, true, shapes);
    }

    public static class_265 exclude(class_265 ... shapes) {
        return VoxelShapeUtils.batchCombine(class_259.method_1077(), class_247.field_16886, true, shapes);
    }

    public static class_265 batchCombine(class_265 initial, class_247 function, boolean simplify, Collection<class_265> shapes) {
        class_265 combinedShape = initial;
        for (class_265 shape : shapes) {
            combinedShape = class_259.method_1082((class_265)combinedShape, (class_265)shape, (class_247)function);
        }
        return simplify ? combinedShape.method_1097() : combinedShape;
    }

    public static class_265 batchCombine(class_265 initial, class_247 function, boolean simplify, class_265 ... shapes) {
        class_265 combinedShape = initial;
        for (class_265 shape : shapes) {
            combinedShape = class_259.method_1082((class_265)combinedShape, (class_265)shape, (class_247)function);
        }
        return simplify ? combinedShape.method_1097() : combinedShape;
    }
}

