/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import net.minecraft.class_243;

public final class WChessUtil {
    public static final String INIT = "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1";

    public static boolean isClickResetArea(class_243 clickPos) {
        double x = clickPos.field_1352;
        double z = clickPos.field_1350;
        if (-0.25 < z && z < 0.25) {
            return 1.125 < x && x < 1.375 || -1.375 < x && x < -1.125;
        }
        return false;
    }

    public static int getClickPosition(class_243 clickPos) {
        double x = (clickPos.field_1352 + 1.0) / 0.25;
        double z = (clickPos.field_1350 + 1.0) / 0.25;
        if (x < 0.0 || z < 0.0) {
            return -1;
        }
        int xFloor = (int)Math.floor(x);
        int zFloor = (int)Math.floor(z);
        if ((xFloor += 4) <= 11 && (zFloor += 0) <= 7) {
            return Position.COORD_XY(xFloor, zFloor);
        }
        return -1;
    }

    public static byte piecesIndex(int x, int y, byte[] data) {
        return data[Position.COORD_XY(x, y)];
    }

    public static boolean isWhite(byte piecesIndex) {
        return (piecesIndex & 8) == 8;
    }

    public static boolean isBlack(byte piecesIndex) {
        return (piecesIndex & 0x10) == 16;
    }

    public static boolean isPlayer(Position position) {
        return position.sdPlayer == 0;
    }

    public static boolean isMaid(Position position) {
        return position.sdPlayer == 1;
    }

    public static boolean reachMoveLimit(Position position) {
        return position.moveNum > 100;
    }

    public static boolean isRepeat(Position position) {
        return position.isRep(2);
    }
}

