/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_863;

@Environment(value=EnvType.CLIENT)
public class MaidAreaRenderEvent {
    private static final Cache<Integer, SchedulePos> CACHE = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();

    public static void onRender(WorldRenderContext context) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        class_243 camera = context.camera().method_19326().method_22882();
        class_4587 poseStack = context.matrixStack();
        Iterator iterator = CACHE.asMap().keySet().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            SchedulePos pos = (SchedulePos)CACHE.getIfPresent((Object)id);
            if (pos == null) continue;
            class_1297 entity = mc.field_1687.method_8469(id);
            if (!(entity instanceof EntityMaid)) {
                return;
            }
            EntityMaid maid = (EntityMaid)entity;
            class_2960 dimension = pos.getDimension();
            if (!mc.field_1724.field_6002.method_27983().method_29177().equals((Object)dimension)) continue;
            MaidAreaRenderEvent.renderPos(pos.getWorkPos(), pos.getIdlePos(), pos.getSleepPos(), camera, poseStack, mc, maid, (class_1657)mc.field_1724);
        }
    }

    private static void renderPos(@Nullable class_2338 workPos, @Nullable class_2338 idlePos, @Nullable class_2338 resetPos, class_243 camera, class_4587 poseStack, class_310 mc, EntityMaid maid, class_1657 player) {
        class_243 prePos;
        String text;
        class_243 textPos;
        class_4588 buffer;
        double radius;
        class_243 centerPos;
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 1.0f, 0.0f);
        class_2338 restrictCenter = maid.method_18412();
        class_243 restrictPos = camera.method_1031((double)restrictCenter.method_10263() + 0.5, (double)restrictCenter.method_10264() + 0.5, (double)restrictCenter.method_10260() + 0.5);
        if (!maid.isHomeModeEnable()) {
            restrictPos = camera.method_1019(player.method_19538());
        }
        class_243 maidPos = camera.method_1019(maid.method_19538());
        RenderHelper.renderLine(poseStack, mc.method_22940().method_23000().getBuffer((class_1921)class_1921.field_21695), restrictPos, maidPos, 1.0f, 0.2f, 0.2f);
        class_238 aabb = maid.method_5829().method_989(0.0, -1.0, 0.0).method_997(camera);
        class_863.method_23102((class_4587)poseStack, (class_4597)mc.method_22940().method_23000(), (class_238)aabb, (float)0.8f, (float)0.8f, (float)0.2f, (float)0.75f);
        if (workPos != null) {
            centerPos = camera.method_1031((double)workPos.method_10263() + 0.5, (double)workPos.method_10264() + 0.5, (double)workPos.method_10260() + 0.5);
            radius = (double)((Integer)MaidConfig.MAID_WORK_RANGE.get()).intValue() + 0.1;
            buffer = mc.method_22940().method_23000().getBuffer((class_1921)class_1921.field_21695);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 1.0f, 0.0f, 0.0f);
            textPos = new class_243((double)workPos.method_10263() + 0.5, (double)(workPos.method_10264() + 2), (double)workPos.method_10260() + 0.5);
            text = class_1074.method_4662((String)"message.touhou_little_maid.kappa_compass.work_area", (Object[])new Object[0]);
            RenderHelper.renderFloatingText(poseStack, text, textPos.field_1352, textPos.field_1351, textPos.field_1350, 0xFF1111, 0.15f, true, -5.0f, false);
            RenderHelper.renderFloatingText(poseStack, "\u25bc", textPos.field_1352, textPos.field_1351, textPos.field_1350, 0xFF1111, 0.15f, true, 5.0f, false);
        }
        if (idlePos != null) {
            centerPos = camera.method_1031((double)idlePos.method_10263() + 0.5, (double)idlePos.method_10264() + 0.5, (double)idlePos.method_10260() + 0.5);
            radius = ((Integer)MaidConfig.MAID_IDLE_RANGE.get()).intValue();
            buffer = mc.method_22940().method_23000().getBuffer((class_1921)class_1921.field_21695);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 0.0f, 1.0f, 0.0f);
            textPos = new class_243((double)idlePos.method_10263() + 0.5, (double)(idlePos.method_10264() + 2), (double)idlePos.method_10260() + 0.5);
            if (idlePos.equals((Object)workPos)) {
                textPos = textPos.method_1031(0.0, 1.0, 0.0);
            } else if (workPos != null) {
                prePos = camera.method_1031((double)workPos.method_10263() + 0.5, (double)workPos.method_10264() + 0.5, (double)workPos.method_10260() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
            }
            text = class_1074.method_4662((String)"message.touhou_little_maid.kappa_compass.idle_area", (Object[])new Object[0]);
            RenderHelper.renderFloatingText(poseStack, text, textPos.field_1352, textPos.field_1351, textPos.field_1350, 0x11FF11, 0.15f, true, -5.0f, false);
            RenderHelper.renderFloatingText(poseStack, "\u25bc", textPos.field_1352, textPos.field_1351, textPos.field_1350, 0x11FF11, 0.15f, true, 5.0f, false);
        }
        if (resetPos != null) {
            centerPos = camera.method_1031((double)resetPos.method_10263() + 0.5, (double)resetPos.method_10264() + 0.5, (double)resetPos.method_10260() + 0.5);
            radius = (double)((Integer)MaidConfig.MAID_SLEEP_RANGE.get()).intValue() - 0.1;
            buffer = mc.method_22940().method_23000().getBuffer((class_1921)class_1921.field_21695);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 0.0f, 0.0f, 1.0f);
            textPos = new class_243((double)resetPos.method_10263() + 0.5, (double)(resetPos.method_10264() + 2), (double)resetPos.method_10260() + 0.5);
            if (resetPos.equals((Object)idlePos)) {
                textPos = textPos.method_1031(0.0, 2.0, 0.0);
            } else if (idlePos != null && workPos != null) {
                prePos = camera.method_1031((double)idlePos.method_10263() + 0.5, (double)idlePos.method_10264() + 0.5, (double)idlePos.method_10260() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
                prePos = camera.method_1031((double)workPos.method_10263() + 0.5, (double)workPos.method_10264() + 0.5, (double)workPos.method_10260() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
            }
            text = class_1074.method_4662((String)"message.touhou_little_maid.kappa_compass.sleep_area", (Object[])new Object[0]);
            RenderHelper.renderFloatingText(poseStack, text, textPos.field_1352, textPos.field_1351, textPos.field_1350, 0x1111FF, 0.15f, true, -5.0f, false);
            RenderHelper.renderFloatingText(poseStack, "\u25bc", textPos.field_1352, textPos.field_1351, textPos.field_1350, 0x1111FF, 0.15f, true, 5.0f, false);
        }
        poseStack.method_22909();
    }

    public static void addSchedulePos(int id, SchedulePos pos) {
        CACHE.put((Object)id, (Object)pos);
    }
}

