/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz.client;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionManager;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionTAC;
import com.github.tartaricacid.touhoulittlemaid.client.entity.GeckoMaidEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.PlayState;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.AnimationBuilder;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.file.AnimationFile;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.resource.index.CommonGunIndex;
import java.util.Locale;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4050;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class GunGeckoAnimation {
    public static PlayState playGrenadeAnimation(AnimationEvent<GeckoMaidEntity<?>> event, class_1268 hand) {
        if (hand == class_1268.field_5808) {
            return GunGeckoAnimation.playLoopAnimation(event, "tac:mainhand:grenade");
        }
        return GunGeckoAnimation.playLoopAnimation(event, "tac:offhand:grenade");
    }

    public static PlayState playGunMainAnimation(AnimationEvent<GeckoMaidEntity<?>> event, String animationName, ILoopType loopType) {
        String tacName = "tac:" + animationName;
        GeckoMaidEntity<?> animatable = event.getAnimatableEntity();
        class_2960 animation = animatable.getAnimationFileLocation();
        AnimationFile animationFile = GeckoLibCache.getInstance().getAnimations().get(animation);
        if (!GunGeckoAnimation.isMaidCarrying(animatable.getMaid()) && animationFile.animations().containsKey(tacName)) {
            return GunGeckoAnimation.playAnimation(event, tacName, loopType);
        }
        return GunGeckoAnimation.playAnimation(event, animationName, loopType);
    }

    public static PlayState playGunHoldAnimation(AnimationEvent<GeckoMaidEntity<?>> event, class_1799 heldItem) {
        IGun gun = IGun.getIGunOrNull((class_1799)heldItem);
        if (gun == null) {
            return PlayState.STOP;
        }
        Optional indexOptional = TimelessAPI.getCommonGunIndex((class_2960)gun.getGunId(heldItem));
        if (indexOptional.isEmpty()) {
            return PlayState.STOP;
        }
        CommonGunIndex gunIndex = (CommonGunIndex)indexOptional.get();
        String weaponType = gunIndex.getType();
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (GunGeckoAnimation.isMaidCarrying(maid)) {
            return PlayState.STOP;
        }
        class_1308 entity = maid.asEntity();
        IGunOperator operator = IGunOperator.fromLivingEntity((class_1309)entity);
        long fireTick = operator.getSynShootCoolDown();
        if (!entity.method_5681() && entity.method_18376() == class_4050.field_18079) {
            if ((double)Math.abs(event.getLimbSwingAmount()) > 0.05) {
                return GunGeckoAnimation.getGunTypeAnimation(event, weaponType, "tac:climb:");
            }
            if (fireTick > 0L) {
                return GunGeckoAnimation.getGunTypeAnimation(event, weaponType, "tac:climbing:fire:");
            }
            return GunGeckoAnimation.getGunTypeAnimation(event, weaponType, "tac:climbing:");
        }
        float reloadProgress = operator.getSynReloadState().getCountDown();
        if (reloadProgress > 0.0f) {
            if (reloadProgress == 1.0f) {
                event.getController().shouldResetTick = true;
                event.getController().adjustTick(0.0);
            }
            return GunGeckoAnimation.getGunTypeAnimation(event, weaponType, "tac:reload:");
        }
        float aimProgress = operator.getSynAimingProgress();
        if (aimProgress > 0.0f) {
            if (fireTick > 0L) {
                return GunGeckoAnimation.getGunTypeAnimation(event, weaponType, "tac:aim:fire:");
            }
            return GunGeckoAnimation.getGunTypeAnimation(event, weaponType, "tac:aim:");
        }
        if (entity.method_24828() && entity.method_5624()) {
            return GunGeckoAnimation.getGunTypeAnimation(event, weaponType, "tac:run:");
        }
        if (fireTick > 0L) {
            return GunGeckoAnimation.getGunTypeAnimation(event, weaponType, "tac:hold:fire:");
        }
        return GunGeckoAnimation.getGunTypeAnimation(event, weaponType, "tac:hold:");
    }

    @NotNull
    private static PlayState getGunTypeAnimation(AnimationEvent<GeckoMaidEntity<?>> event, String weaponType, String prefix) {
        class_2960 modelId = event.getAnimatableEntity().getAnimationFileLocation();
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        class_1308 entity = maid.asEntity();
        ConditionTAC conditionTAC = ConditionManager.getTAC(modelId);
        if (conditionTAC != null) {
            class_1799 stack = entity.method_6047();
            String name = conditionTAC.doTest(stack, prefix);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name})) {
                return GunGeckoAnimation.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        if (GunGeckoAnimation.isType(weaponType, GunTabType.PISTOL)) {
            return GunGeckoAnimation.playLoopAnimation(event, prefix + "pistol");
        }
        if (GunGeckoAnimation.isType(weaponType, GunTabType.RPG)) {
            return GunGeckoAnimation.playLoopAnimation(event, prefix + "rpg");
        }
        return GunGeckoAnimation.playLoopAnimation(event, prefix + "rifle");
    }

    @NotNull
    private static PlayState playLoopAnimation(AnimationEvent<?> event, String animationName) {
        return GunGeckoAnimation.playAnimation(event, animationName, ILoopType.EDefaultLoopTypes.LOOP);
    }

    @NotNull
    private static PlayState playAnimation(AnimationEvent<?> event, String animationName, ILoopType loopType) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation(animationName, loopType));
        return PlayState.CONTINUE;
    }

    private static boolean isType(String type, GunTabType tabType) {
        return type.equals(tabType.name().toLowerCase(Locale.ENGLISH));
    }

    private static boolean isMaidCarrying(IMaid maid) {
        class_1308 entity = maid.asEntity();
        return entity.method_5854() instanceof class_1657;
    }
}

