/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.jei.altar;

import com.github.tartaricacid.touhoulittlemaid.compat.jei.altar.AltarRecipeWrapper;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class AltarRecipeCategory
implements IRecipeCategory<AltarRecipeWrapper> {
    public static final RecipeType<AltarRecipeWrapper> ALTAR = RecipeType.create((String)"touhou_little_maid", (String)"altar", AltarRecipeWrapper.class);
    private static final class_2960 ALTAR_ICON = class_2960.method_60655((String)"touhou_little_maid", (String)"textures/gui/altar_icon.png");
    private static final class_2960 POWER_ICON = class_2960.method_60655((String)"touhou_little_maid", (String)"textures/entity/power_point.png");
    private static final class_5250 TITLE = class_2561.method_43471((String)"jei.touhou_little_maid.altar_craft.title");
    private final IDrawableStatic bgDraw;
    private final IDrawable slotDraw;
    private final IDrawableStatic altarDraw;
    private final IDrawableStatic powerDraw;

    public AltarRecipeCategory(IGuiHelper guiHelper) {
        this.bgDraw = guiHelper.createBlankDrawable(160, 125);
        this.slotDraw = guiHelper.getSlotDrawable();
        this.altarDraw = guiHelper.drawableBuilder(ALTAR_ICON, 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.powerDraw = guiHelper.drawableBuilder(POWER_ICON, 32, 0, 16, 16).setTextureSize(64, 64).build();
    }

    public void draw(AltarRecipeWrapper recipe, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        int darkGray = 0x555555;
        class_327 font = class_310.method_1551().field_1772;
        String result = class_1074.method_4662((String)"jei.touhou_little_maid.altar_craft.result", (Object[])new Object[]{class_1074.method_4662((String)recipe.getLangKey(), (Object[])new Object[0])});
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(0.8f, 0.8f, 0.8f);
        this.powerDraw.draw(graphics, 90, 50);
        graphics.method_51448().method_22909();
        graphics.method_51433(font, String.format("\u00d7%.2f", Float.valueOf(recipe.getPowerCost())), 65, 55, darkGray, false);
        graphics.method_51433(font, result, (int)((float)(this.bgDraw.getWidth() - font.method_1727(result)) / 2.0f), 85, darkGray, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AltarRecipeWrapper recipe, IFocusGroup focuses) {
        List<List<class_1799>> inputs = recipe.getInputs();
        class_1799 output = recipe.getOutput();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 40, 35).addItemStacks(this.getInput(inputs, 0))).setBackground(this.slotDraw, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 40, 55).addItemStacks(this.getInput(inputs, 1))).setBackground(this.slotDraw, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 60, 15).addItemStacks(this.getInput(inputs, 2))).setBackground(this.slotDraw, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 80, 15).addItemStacks(this.getInput(inputs, 3))).setBackground(this.slotDraw, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 100, 35).addItemStacks(this.getInput(inputs, 4))).setBackground(this.slotDraw, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 100, 55).addItemStacks(this.getInput(inputs, 5))).setBackground(this.slotDraw, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 140, 5).addItemStack(output)).setBackground(this.slotDraw, -1, -1);
    }

    private List<class_1799> getInput(List<List<class_1799>> inputs, int index) {
        if (index < inputs.size()) {
            return inputs.get(index);
        }
        return Collections.singletonList(class_1799.field_8037);
    }

    public RecipeType<AltarRecipeWrapper> getRecipeType() {
        return ALTAR;
    }

    public class_2561 getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.bgDraw;
    }

    public IDrawable getIcon() {
        return this.altarDraw;
    }
}

