/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.crafting;

import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_7710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class AltarRecipeSerializer
implements class_1865<AltarRecipe> {
    public static final MapCodec<AltarRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(AltarRecipe::method_8112), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(AltarRecipe::getCategory), (App)class_1856.field_46095.listOf().fieldOf("ingredients").flatXmap(AltarRecipeSerializer::checkIngredients, DataResult::success).forGetter(class_1867::method_8117), (App)Codec.FLOAT.fieldOf("power").forGetter(AltarRecipe::getPower), (App)class_1799.field_51397.fieldOf("result").forGetter(AltarRecipe::getResult), (App)class_2960.field_25139.fieldOf("entity").forGetter(AltarRecipe::getEntityType), (App)Codec.STRING.optionalFieldOf("lang", (Object)"").forGetter(AltarRecipe::getLangKey)).apply((Applicative)instance, AltarRecipe::new));

    @NotNull
    private static DataResult<class_2371<class_1856>> checkIngredients(List<class_1856> ingredientList) {
        Object[] aingredient = (class_1856[])ingredientList.toArray(class_1856[]::new);
        if (aingredient.length == 0) {
            return DataResult.error(() -> "No ingredients for shapeless recipe");
        }
        if (aingredient.length > 6) {
            return DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: 6");
        }
        return DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])aingredient));
    }

    private AltarRecipe fromNetwork(class_9129 byteBuf) {
        String group = byteBuf.method_19772();
        class_7710 category = (class_7710)byteBuf.method_10818(class_7710.class);
        class_2371 ingredients = class_2371.method_10213((int)byteBuf.method_10816(), (Object)class_1856.field_9017);
        ingredients.replaceAll(ingredient -> (class_1856)class_1856.field_48355.decode((Object)byteBuf));
        float power = byteBuf.readFloat();
        class_1799 result = (class_1799)class_1799.field_48349.decode((Object)byteBuf);
        class_2960 entityType = byteBuf.method_10810();
        String langKey = byteBuf.method_19772();
        return new AltarRecipe(group, category, (class_2371<class_1856>)ingredients, power, result, entityType, langKey);
    }

    private void toNetwork(class_9129 friendlyByteBuf, AltarRecipe altarRecipe) {
        friendlyByteBuf.method_10814(altarRecipe.method_8112());
        friendlyByteBuf.method_10817((Enum)altarRecipe.getCategory());
        friendlyByteBuf.method_10804(altarRecipe.method_8117().size());
        for (class_1856 ingredient : altarRecipe.method_8117()) {
            class_1856.field_48355.encode((Object)friendlyByteBuf, (Object)ingredient);
        }
        friendlyByteBuf.method_52941(altarRecipe.getPower());
        class_1799.field_48349.encode((Object)friendlyByteBuf, (Object)altarRecipe.getResult());
        friendlyByteBuf.method_10812(altarRecipe.getEntityType());
        friendlyByteBuf.method_10814(altarRecipe.getLangKey());
    }

    public MapCodec<AltarRecipe> method_53736() {
        return CODEC;
    }

    public class_9139<class_9129, AltarRecipe> method_56104() {
        return class_9139.method_56437(this::toNetwork, this::fromNetwork);
    }
}

