/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.RangedWrapper;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.IMaidMeal;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.MaidMealType;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.meal.MaidMealManager;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class MaidHealSelfTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 50;
    private static final int MAX_CHECK_MISSING_HEATH = 2;

    public MaidHealSelfTask() {
        super((Map<class_4140<?>, class_4141>)ImmutableMap.of());
        this.setMaxCheckRate(50);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 serverLevel, EntityMaid maid) {
        if (super.checkExtraStartConditions(serverLevel, maid)) {
            float missingHealth = maid.method_6063() - maid.method_6032();
            return !maid.method_6113() && maid.getTask().enableEating(maid) && missingHealth >= 2.0f;
        }
        return false;
    }

    protected void start(class_3218 serverLevel, EntityMaid maid, long gameTime) {
        List<IMaidMeal> maidMeals = MaidMealManager.getMaidMeals(MaidMealType.HEAL_MEAL);
        for (class_1268 hand : class_1268.values()) {
            class_1799 itemInHand = maid.method_5998(hand);
            if (itemInHand.method_7960()) continue;
            for (IMaidMeal maidMeal : maidMeals) {
                if (!maidMeal.canMaidEat(maid, itemInHand, hand)) continue;
                maidMeal.onMaidEat(maid, itemInHand, hand);
                return;
            }
        }
        class_1268 eanHand = class_1268.field_5810;
        for (class_1268 hand : class_1268.values()) {
            if (!maid.method_5998(hand).method_7960()) continue;
            eanHand = hand;
            break;
        }
        class_1799 itemInHand = maid.method_5998(eanHand);
        boolean hasFood = false;
        RangedWrapper backpackInv = maid.getAvailableBackpackInv();
        block3: for (int i = 0; i < backpackInv.getSlots(); ++i) {
            class_1799 stack = backpackInv.getStackInSlot(i);
            if (stack.method_7960()) continue;
            for (IMaidMeal maidMeal : maidMeals) {
                if (!maidMeal.canMaidEat(maid, stack, eanHand)) continue;
                class_1799 foodStack = backpackInv.extractItem(i, backpackInv.getStackInSlot(i).method_7947(), false);
                class_1799 handStack = itemInHand.method_7972();
                maid.method_6122(eanHand, foodStack);
                itemInHand = maid.method_5998(eanHand);
                maid.memoryHandItemStack(handStack);
                hasFood = true;
                break block3;
            }
        }
        if (hasFood) {
            for (IMaidMeal maidMeal : maidMeals) {
                if (!maidMeal.canMaidEat(maid, itemInHand, eanHand)) continue;
                maidMeal.onMaidEat(maid, itemInHand, eanHand);
                return;
            }
        }
    }
}

