/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class MaidPickupEntitiesTask
extends class_4097<EntityMaid> {
    private static long GLOBAL_NEXT_SCHEDULE_AT = 0L;
    private final Predicate<EntityMaid> predicate;
    private final float speedModifier;

    public MaidPickupEntitiesTask(float speedModifier) {
        this((Predicate<EntityMaid>)Predicates.alwaysTrue(), speedModifier);
    }

    public MaidPickupEntitiesTask(Predicate<EntityMaid> predicate, float speedModifier) {
        super((Map)ImmutableMap.of(InitEntities.VISIBLE_PICKUP_ENTITIES, (Object)class_4141.field_18456, (Object)class_4140.field_18445, (Object)class_4141.field_18457));
        this.predicate = predicate;
        this.speedModifier = speedModifier;
    }

    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        return owner.method_6181() && owner.canBrainMoving() && this.predicate.test(owner);
    }

    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        List<class_1297> items = this.getItems(maid);
        MaidPathFindingBFS pathFinding = new MaidPathFindingBFS(maid.method_5942().method_6342(), worldIn, maid);
        for (class_1297 entity : items) {
            class_2338 blockPos = entity.method_24515();
            if (!maid.method_18407(blockPos) || !entity.method_5805() || entity.method_5799() || !pathFinding.canPathReach(blockPos)) continue;
            class_4215.method_24557((class_1309)maid, (class_1297)entity, (float)this.speedModifier, (int)0);
            break;
        }
        pathFinding.finish();
    }

    private List<class_1297> getItems(EntityMaid maid) {
        return maid.method_18868().method_18904(InitEntities.VISIBLE_PICKUP_ENTITIES).orElse(Lists.newArrayList());
    }
}

