/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.favorability;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidFavorabilityLevelChangeEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticlePackage;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class FavorabilityManager {
    public static final Map<String, Type> TYPES = Maps.newHashMap();
    private static final int LEVEL_0 = 0;
    private static final int LEVEL_1 = 1;
    private static final int LEVEL_2 = 2;
    private static final int LEVEL_3 = 3;
    private static final int LEVEL_0_POINT = 0;
    private static final int LEVEL_1_POINT = 64;
    private static final int LEVEL_2_POINT = 192;
    private static final int LEVEL_3_POINT = 384;
    private static final int LEVEL_0_HEALTH = 20;
    private static final int LEVEL_1_HEALTH = 30;
    private static final int LEVEL_2_HEALTH = 40;
    private static final int LEVEL_3_HEALTH = 80;
    private static final int LEVEL_0_ATTACK_DAMAGE = 2;
    private static final int LEVEL_1_ATTACK_DAMAGE = 3;
    private static final int LEVEL_2_ATTACK_DAMAGE = 4;
    private static final int LEVEL_3_ATTACK_DAMAGE = 6;
    private static final int LEVEL_0_ATTACK_DISTANCE_PLUS = 0;
    private static final int LEVEL_1_ATTACK_DISTANCE_PLUS = 1;
    private static final int LEVEL_2_ATTACK_DISTANCE_PLUS = 3;
    private static final int LEVEL_3_ATTACK_DISTANCE_PLUS = 5;
    private static final double LEVEL_0_SWEEP_RANGE = 1.0;
    private static final double LEVEL_1_SWEEP_RANGE = 2.0;
    private static final double LEVEL_2_SWEEP_RANGE = 3.0;
    private static final double LEVEL_3_SWEEP_RANGE = 4.0;
    private static final String TAG_NAME = "FavorabilityManagerCounter";
    private final Map<String, Time> counter = Maps.newHashMap();
    private final EntityMaid maid;

    public FavorabilityManager(EntityMaid maid) {
        this.maid = maid;
    }

    public void tick() {
        this.counter.values().forEach(Time::tick);
    }

    public void apply(String type) {
        Type typeInstance = TYPES.get(type);
        if (typeInstance != null) {
            this.apply(typeInstance);
        }
    }

    public void apply(Type type) {
        if (this.canAdd(type.getTypeName())) {
            if (type.isReduce()) {
                this.reduce(type.getPoint());
            } else {
                this.add(type.getPoint());
            }
            this.addCooldown(type.getTypeName(), type.getCooldown());
        }
    }

    public void apply(Type type, int point) {
        if (this.canAdd(type.getTypeName())) {
            if (type.isReduce()) {
                this.reduce(point);
            } else {
                this.add(point);
            }
            this.addCooldown(type.getTypeName(), type.getCooldown());
        }
    }

    private void addCooldown(String type, int tickCount) {
        this.counter.put(type, new Time(tickCount));
    }

    public boolean canAdd(String type) {
        if (this.counter.containsKey(type)) {
            return this.counter.get(type).isZero();
        }
        return true;
    }

    public int getLevel() {
        return this.getLevel(this.maid.getFavorability());
    }

    private int getLevel(int favorability) {
        if (favorability < 64) {
            return 0;
        }
        if (favorability < 192) {
            return 1;
        }
        if (favorability < 384) {
            return 2;
        }
        return 3;
    }

    public double getLevelPercent() {
        int favorability = this.maid.getFavorability();
        if (favorability < 64) {
            return (double)favorability / 64.0;
        }
        if (favorability < 192) {
            return (double)(favorability - 64) / 128.0;
        }
        if (favorability < 384) {
            return (double)(favorability - 192) / 192.0;
        }
        return 0.0;
    }

    public int nextLevelPoint() {
        int level = this.getLevel();
        if (level == 3) {
            return 0;
        }
        int pointByLevel = this.getPointByLevel(level + 1);
        return pointByLevel - this.maid.getFavorability();
    }

    public int getHealthByLevel(int level) {
        switch (level) {
            case 1: {
                return 30;
            }
            case 2: {
                return 40;
            }
            case 3: {
                return 80;
            }
        }
        return 20;
    }

    public int getAttackByLevel(int level) {
        switch (level) {
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 6;
            }
        }
        return 2;
    }

    public int getAttackDistancePlusByPoint(int favorability) {
        if (favorability < 64) {
            return 0;
        }
        if (favorability < 192) {
            return 1;
        }
        if (favorability < 384) {
            return 3;
        }
        return 5;
    }

    public class_238 getSweepRange(class_1297 target, int favorability) {
        class_238 boundingBox = target.method_5829();
        if (favorability < 64) {
            return this.sweepRangeTransform(boundingBox, 1.0);
        }
        if (favorability < 192) {
            return this.sweepRangeTransform(boundingBox, 2.0);
        }
        if (favorability < 384) {
            return this.sweepRangeTransform(boundingBox, 3.0);
        }
        return this.sweepRangeTransform(boundingBox, 4.0);
    }

    private class_238 sweepRangeTransform(class_238 boundingBox, double range) {
        return boundingBox.method_1009(range, Math.max(range / 4.0, 0.25), range);
    }

    public int getPointByLevel(int level) {
        switch (level) {
            case 1: {
                return 64;
            }
            case 2: {
                return 192;
            }
            case 3: {
                return 384;
            }
        }
        return 0;
    }

    public void add(int addPoint) {
        int favorability = this.maid.getFavorability();
        int levelBefore = this.getLevel();
        int result = class_3532.method_15340((int)(favorability + addPoint), (int)0, (int)384);
        this.maid.setFavorability(result);
        int levelAfter = this.getLevel();
        if (levelBefore < levelAfter) {
            class_3222 serverPlayer;
            class_1309 class_13092;
            class_1324 attack = this.maid.method_5996(class_5134.field_23721);
            class_1324 health = this.maid.method_5996(class_5134.field_23716);
            if (attack != null) {
                attack.method_6192((double)this.getAttackByLevel(levelAfter));
            }
            if (health != null) {
                if (this.maid.isStruckByLightning()) {
                    health.method_6192((double)(this.getHealthByLevel(levelAfter) + 20));
                } else {
                    health.method_6192((double)this.getHealthByLevel(levelAfter));
                }
                if (this.maid.method_6032() > this.maid.method_6063()) {
                    this.maid.method_6033(this.maid.method_6063());
                }
                if (this.maid.method_6063() >= 100.0f && (class_13092 = this.maid.method_35057()) instanceof class_3222) {
                    serverPlayer = (class_3222)class_13092;
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, "maid_100_healthy");
                }
            }
            if ((class_13092 = this.maid.method_35057()) instanceof class_3222) {
                serverPlayer = (class_3222)class_13092;
                InitTrigger.MAID_EVENT.trigger(serverPlayer, "favorability_increased");
                if (levelAfter == 3) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, "favorability_increased_max");
                }
            }
            this.onFavorabilityLevelChange(levelBefore, levelAfter);
        }
        NetworkHandler.sendToNearby((class_1297)this.maid, new SpawnParticlePackage(this.maid.method_5628(), SpawnParticlePackage.Type.HEART));
    }

    public void reduce(int reducePoint) {
        int favorability = this.maid.getFavorability();
        int pointByLevel = this.getPointByLevel(this.getLevel());
        int result = class_3532.method_15340((int)(favorability - reducePoint), (int)pointByLevel, (int)384);
        this.maid.setFavorability(result);
    }

    public void reduceWithoutLevel(int reducePoint) {
        int favorability = this.maid.getFavorability();
        int levelBefore = this.getLevel();
        int result = class_3532.method_15340((int)(favorability - reducePoint), (int)0, (int)384);
        this.maid.setFavorability(result);
        int levelAfter = this.getLevel();
        if (levelBefore > levelAfter) {
            class_1324 attack = this.maid.method_5996(class_5134.field_23721);
            class_1324 health = this.maid.method_5996(class_5134.field_23716);
            if (attack != null) {
                attack.method_6192((double)this.getAttackByLevel(levelAfter));
            }
            if (health != null) {
                if (this.maid.isStruckByLightning()) {
                    health.method_6192((double)(this.getHealthByLevel(levelAfter) + 20));
                } else {
                    health.method_6192((double)this.getHealthByLevel(levelAfter));
                }
                if (this.maid.method_6032() > this.maid.method_6063()) {
                    this.maid.method_6033(this.maid.method_6063());
                }
            }
            this.onFavorabilityLevelChange(levelBefore, levelAfter);
        }
    }

    public void onFavorabilityLevelChange(int oldLevel, int newLevel) {
        this.maid.getMaidBauble().fireEvent((b, s) -> {
            b.onFavorabilityLevelChange(this.maid, (class_1799)s, oldLevel, newLevel);
            return false;
        });
        ((MaidFavorabilityLevelChangeEvent.Callback)MaidFavorabilityLevelChangeEvent.CALLBACK.invoker()).post(new MaidFavorabilityLevelChangeEvent(this.maid, oldLevel, newLevel));
    }

    public void max() {
        this.add(384);
    }

    public void addAdditionalSaveData(class_2487 compound) {
        class_2487 data = new class_2487();
        this.counter.forEach((name, time) -> data.method_10569(name, time.getTickCount()));
        compound.method_10566(TAG_NAME, (class_2520)data);
    }

    public void readAdditionalSaveData(class_2487 compound) {
        if (compound.method_10573(TAG_NAME, 10)) {
            class_2487 data = compound.method_10562(TAG_NAME);
            for (String name : data.method_10541()) {
                this.counter.put(name, new Time(data.method_10550(name)));
            }
        }
    }

    public static class Time {
        private int tickCount;

        public Time(int tickCount) {
            this.tickCount = tickCount;
        }

        public int getTickCount() {
            return this.tickCount;
        }

        public void setTickCount(int tickCount) {
            this.tickCount = tickCount;
        }

        public void tick() {
            if (this.tickCount > 0) {
                --this.tickCount;
            }
        }

        public boolean isZero() {
            return this.tickCount <= 0;
        }
    }
}

