package cn.sh1rocu.touhoulittlemaid.util.forge.network;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
// From NeoForge && PortingLib

/**
 * Payload that can be sent from the server to the client to add an entity to the world, with custom data.
 *
 * @param entityId      The id of the entity to add.
 * @param customPayload The custom data of the entity to add.
 */
@ApiStatus.Internal
public record AdvancedAddEntityPayload(int entityId, byte[] customPayload) implements class_8710 {
    public static final class_9154<AdvancedAddEntityPayload> TYPE = new class_9154<>(class_2960.method_60655(TouhouLittleMaid.MOD_ID, "advanced_add_entity"));
    public static final class_9139<class_2540, AdvancedAddEntityPayload> STREAM_CODEC = class_9139.method_56435(
            class_9135.field_48550,
            AdvancedAddEntityPayload::entityId,
            class_9135.field_48987,
            AdvancedAddEntityPayload::customPayload,
            AdvancedAddEntityPayload::new);

    public AdvancedAddEntityPayload(class_1297 e) {
        this(e.method_5628(), writeCustomData(e));
    }

    private static byte[] writeCustomData(final class_1297 entity) {
        if (!(entity instanceof IEntityWithComplexSpawn additionalSpawnData)) {
            return new byte[0];
        }

        final class_9129 buf = new class_9129(Unpooled.buffer(), entity.method_56673());
        try {
            additionalSpawnData.writeSpawnData(buf);
            return buf.array();
        } finally {
            buf.release();
        }
    }

    @Environment(EnvType.CLIENT)
    public static void handle(AdvancedAddEntityPayload message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            try {
                class_1297 entity = context.player().method_37908().method_8469(message.entityId());
                if (entity instanceof IEntityWithComplexSpawn entityAdditionalSpawnData) {
                    final class_9129 buf = new class_9129(Unpooled.wrappedBuffer(message.customPayload()), entity.method_56673());
                    try {
                        entityAdditionalSpawnData.readSpawnData(buf);
                    } finally {
                        buf.release();
                    }
                }
            } catch (Throwable t) {
                TouhouLittleMaid.LOGGER.error("Failed to handle advanced add entity from server.", t);
                context.responseSender().disconnect(class_2561.method_43470("Failed to send AdvancedAddEntityPayload to client"));
            }
        });
    }

    @Override
    public class_9154<AdvancedAddEntityPayload> method_56479() {
        return TYPE;
    }
}
