package com.github.tartaricacid.touhoulittlemaid.advancements.maid;

import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_175;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;

public class MaidEventTrigger extends class_4558<MaidEventTrigger.Instance> {
    public static class_175<Instance> create(String eventName) {
        return InitTrigger.MAID_EVENT.method_53699(new Instance(Optional.empty(), eventName));
    }

    public void trigger(class_3222 serverPlayer, String eventName) {
        super.method_22510(serverPlayer, instance -> instance.matches(eventName));
    }

    @Override
    public Codec<Instance> method_54937() {
        return Instance.CODEC;
    }

    public record Instance(Optional<class_5258> player, String eventName) implements SimpleInstance {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group(
                        class_2048.field_47250.optionalFieldOf("player").forGetter(Instance::player),
                        Codec.STRING.fieldOf("event").forGetter(Instance::eventName))
                .apply(instance, Instance::new));

        public boolean matches(String eventNameIn) {
            return this.eventName.equals(eventNameIn);
        }
    }
}
