package com.github.tartaricacid.touhoulittlemaid.api.event;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1308;
import org.jetbrains.annotations.Nullable;

/**
 * 其他模组作者可以捕获此事件 <br>
 * 调用 setMaid 方法，传入 IMaid 实例 <br>
 * 即可调用女仆渲染
 */
public class ConvertMaidEvent {
    private final class_1308 mob;
    private @Nullable IMaid maid;

    public ConvertMaidEvent(class_1308 mob) {
        this.mob = mob;
    }

    public class_1308 getEntity() {
        return mob;
    }

    public void setMaid(IMaid maid) {
        this.maid = maid;
    }

    @Nullable
    public IMaid getMaid() {
        return maid;
    }

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.post(event);
        }
    });

    public interface Callback {
        void post(ConvertMaidEvent event);
    }
}
