package com.github.tartaricacid.touhoulittlemaid.client.animation.script;

import com.github.tartaricacid.touhoulittlemaid.api.animation.IChairData;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import net.minecraft.class_1657;

public final class EntityChairWrapper implements IChairData {
    private final WorldWrapper world = new WorldWrapper();
    private EntityChair chair;

    public void setData(EntityChair chair) {
        this.chair = chair;
        this.world.setData(chair.method_37908());
    }

    public void clearData() {
        this.chair = null;
        this.world.clearData();
    }

    @Override
    public boolean isRidingPlayer() {
        return chair.method_5642() instanceof class_1657;
    }

    @Override
    public boolean hasPassenger() {
        return !chair.method_5685().isEmpty();
    }

    @Override
    public float getPassengerYaw() {
        if (!chair.method_5685().isEmpty()) {
            return chair.method_5685().get(0).method_36454();
        }
        return 0;
    }

    @Override
    public float getYaw() {
        return chair.method_36454();
    }

    @Override
    public float getPassengerPitch() {
        if (!chair.method_5685().isEmpty()) {
            return chair.method_5685().get(0).method_36455();
        }
        return 0;
    }

    @Override
    public WorldWrapper getWorld() {
        return world;
    }

    @Override
    public long getSeed() {
        return Math.abs(chair.method_5667().getLeastSignificantBits());
    }

    @Override
    @Deprecated
    public int getDim() {
        return chair.getDim();
    }
}
