package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai.AIChatScreen;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_239;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

@Environment(EnvType.CLIENT)
public class PressAIChatKeyEvent {
    public static void onOpenConfig(int key, int scanCode, int action, int mods) {
        if (isInGame() && AIConfig.LLM_ENABLED.get() && keyIsMatch(key, scanCode, action, mods)) {
            EntityMaid maid = maidCheck();
            if (maid == null) {
                return;
            }
            class_310.method_1551().field_1690.field_1890.method_1436();
            class_310.method_1551().method_1507(new AIChatScreen(maid));
        }
    }

    private static boolean keyIsMatch(int key, int scanCode, int action, int mods) {
        class_304 keyChat = class_310.method_1551().field_1690.field_1890;
        return action == GLFW.GLFW_PRESS
                && keyChat.method_1417(key, scanCode)
                /*&&keyChat.getKeyModifier().equals(KeyModifier.getActiveModifier())*/;
    }

    @Nullable
    private static EntityMaid maidCheck() {
        // 玩家不为空或者观察者模式
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || player.method_7325()) {
            return null;
        }
        // 当前鼠标指向了特定的女仆
        class_310 mc = class_310.method_1551();
        class_239 hitResult = mc.field_1765;
        if (!(hitResult instanceof class_3966 entityHitResult)) {
            return null;
        }
        if (!(entityHitResult.method_17782() instanceof EntityMaid maid)) {
            return null;
        }
        if (!maid.method_6171(player)) {
            return null;
        }
        return maid;
    }

    private static boolean isInGame() {
        class_310 mc = class_310.method_1551();
        // 不能是加载界面
        if (mc.method_18506() != null) {
            return false;
        }
        // 不能打开任何 GUI
        if (mc.field_1755 != null) {
            return false;
        }
        // 当前窗口捕获鼠标操作
        if (!mc.field_1729.method_1613()) {
            return false;
        }
        // 选择了当前窗口
        return mc.method_1569();
    }
}
