package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.CombinedInvWrapper;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemHandlerHelper;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1430;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import net.minecraft.class_6670;

public class MaidMilkTask extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 40;
    private final float speedModifier;
    private class_1309 milkTarget = null;

    public MaidMilkTask(float speedModifier) {
        super(ImmutableMap.of(class_4140.field_18442, class_4141.field_18456,
                class_4140.field_18445, class_4141.field_18457));
        this.speedModifier = speedModifier;
        this.setMaxCheckRate(MAX_DELAY_TIME);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        if (super.checkExtraStartConditions(worldIn, owner)) {
            CombinedInvWrapper availableInv = owner.getAvailableInv(true);
            return ItemsUtil.isStackIn(availableInv, stack -> stack.method_7909() == class_1802.field_8550) &&
                    ItemsUtil.isStackIn(availableInv, stack -> stack == class_1799.field_8037);
        }
        return false;
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        milkTarget = null;
        this.getEntities(maid)
                .method_38980(e -> maid.method_18407(e.method_24515()))
                .filter(class_1297::method_5805)
                .filter(e -> e instanceof class_1430)
                .filter(e -> !e.method_6109())
                .filter(maid::canPathReach)
                .findFirst()
                .ifPresent(e -> {
                    milkTarget = e;
                    class_4215.method_24557(maid, e, this.speedModifier, 0);
                });

        if (milkTarget != null && milkTarget.method_24516(maid, 2)) {
            CombinedInvWrapper availableInv = maid.getAvailableInv(false);
            class_1799 bucket = ItemsUtil.getStack(availableInv, stack -> stack.method_7909() == class_1802.field_8550);
            if (bucket != class_1799.field_8037) {
                bucket.method_7934(1);
                ItemHandlerHelper.insertItemStacked(availableInv, new class_1799(class_1802.field_8103), false);
            }
            maid.method_6104(class_1268.field_5808);
            maid.method_5783(class_3417.field_14691, 1.0F, 1.0F);
            milkTarget = null;
        }
    }

    private class_6670 getEntities(EntityMaid maid) {
        return maid.method_18868().method_18904(class_4140.field_18442).orElse(class_6670.method_38971());
    }
}
