package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class MaidPickupEntitiesTask extends class_4097<EntityMaid> {
    private final Predicate<EntityMaid> predicate;
    private final float speedModifier;

    public MaidPickupEntitiesTask(float speedModifier) {
        this(Predicates.alwaysTrue(), speedModifier);
    }

    public MaidPickupEntitiesTask(Predicate<EntityMaid> predicate, float speedModifier) {
        super(ImmutableMap.of(InitEntities.VISIBLE_PICKUP_ENTITIES, class_4141.field_18456,
                class_4140.field_18445, class_4141.field_18457));
        this.predicate = predicate;
        this.speedModifier = speedModifier;
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        return owner.method_6181() && owner.canBrainMoving() && predicate.test(owner);
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        List<class_1297> items = this.getItems(maid);
        for (class_1297 entity : items) {
            if (maid.method_18407(entity.method_24515())
                    && entity.method_5805()
                    && !entity.method_5799()
                    && maid.canPathReach(entity)) {
                class_4215.method_24557(maid, entity, this.speedModifier, 0);
                return;
            }
        }
    }

    private List<class_1297> getItems(EntityMaid maid) {
        return maid.method_18868().method_18904(InitEntities.VISIBLE_PICKUP_ENTITIES).orElse(Lists.newArrayList());
    }
}
