package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_3218;
import net.minecraft.class_4118;
import net.minecraft.class_7893;

public class MaidRunOne extends class_4118<EntityMaid> {
    private final Predicate<EntityMaid> enableCondition;

    public MaidRunOne(List<Pair<? extends class_7893<? super EntityMaid>, Integer>> entryCondition, Predicate<EntityMaid> enableCondition) {
        super(entryCondition);
        this.enableCondition = enableCondition;
    }

    public MaidRunOne(List<Pair<? extends class_7893<? super EntityMaid>, Integer>> entryCondition) {
        this(entryCondition, maid -> true);
    }

    @Override
    public boolean tryStart(class_3218 pLevel, EntityMaid maid, long pGameTime) {
        if (!enableCondition.test(maid)) {
            return false;
        }
        return !maid.isBegging() && !maid.method_6113() && !(maid.method_5854() instanceof EntitySit) && super.method_18922(pLevel, maid, pGameTime);
    }
}