package com.github.tartaricacid.touhoulittlemaid.entity.ai.goal;

import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityFairy;
import java.util.EnumSet;
import net.minecraft.class_11;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_243;

public class FairyAttackGoal extends class_1352 {
    private static final int MAX_WITH_IN_RANGE_TIME = 20;
    private final EntityFairy entityFairy;
    private final double minDistance;
    private final double speedIn;
    private class_11 path;
    private int withInRangeTime;

    public FairyAttackGoal(EntityFairy entityFairy, double minDistance, double speedIn) {
        this.entityFairy = entityFairy;
        this.minDistance = minDistance;
        this.speedIn = speedIn;
        this.method_6265(EnumSet.of(class_4134.field_18408));
    }

    @Override
    public boolean method_6264() {
        class_1309 target = this.entityFairy.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        this.path = this.entityFairy.method_5942().method_6349(target, 0);
        return path != null;
    }

    @Override
    public void method_6269() {
        this.entityFairy.method_5942().method_6334(this.path, this.speedIn);
    }

    @Override
    public void method_6268() {
        class_1309 target = this.entityFairy.method_5968();
        if (target == null || !target.method_5805()) {
            return;
        }
        this.entityFairy.method_5988().method_6226(target, 30.0F, 30.0F);
        double distance = this.entityFairy.method_5739(target);
        if (this.entityFairy.method_5985().method_6369(target) && distance >= minDistance) {
            this.entityFairy.method_5942().method_6335(target, this.speedIn);
            withInRangeTime = 0;
        } else if (distance < minDistance) {
            this.entityFairy.method_5942().method_6340();
            withInRangeTime++;
            class_243 motion = entityFairy.method_18798();
            entityFairy.method_18800(motion.field_1352, 0, motion.field_1350);
            entityFairy.method_5875(true);
            if (withInRangeTime > MAX_WITH_IN_RANGE_TIME) {
                float percent = (float) (distance / minDistance);
                entityFairy.method_7105(target, 1 - percent);
                withInRangeTime = 0;
            }
        } else {
            withInRangeTime = 0;
        }
    }

    @Override
    public boolean method_6266() {
        class_1309 target = this.entityFairy.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        } else {
            boolean isPlayerAndCanNotBeAttacked = target instanceof class_1657
                    && (target.method_7325() || ((class_1657) target).method_7337());
            return !isPlayerAndCanNotBeAttacked;
        }
    }

    @Override
    public void method_6270() {
        class_1309 target = this.entityFairy.method_5968();
        boolean isPlayerAndCanNotBeAttacked = target instanceof class_1657
                && (target.method_7325() || ((class_1657) target).method_7337());
        if (isPlayerAndCanNotBeAttacked) {
            this.entityFairy.method_5980(null);
        }
        this.entityFairy.method_5942().method_6340();
        withInRangeTime = 0;
    }
}
