package cn.sh1rocu.touhoulittlemaid.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1282;
import net.minecraft.class_1309;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.*;

public class LivingHurtEvent extends CancellableEvent {
    private final class_1309 livingEntity;
    private final class_1282 source;
    private float amount;
    public static final Event<Callback> CALLBACK = EventFactory.createWithPhases(Callback.class, callbacks -> event -> {
        for (Callback e : callbacks)
            e.onLivingHurt(event);
    }, HIGHEST, HIGH, Event.DEFAULT_PHASE, LOW, LOWEST);

    public LivingHurtEvent(class_1309 entity, class_1282 source, float amount) {
        this.livingEntity = entity;
        this.source = source;
        this.amount = amount;
    }

    public class_1309 getEntity() {
        return livingEntity;
    }

    public class_1282 getSource() {
        return source;
    }

    public float getAmount() {
        return amount;
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public interface Callback {
        void onLivingHurt(LivingHurtEvent event);
    }
}