package com.github.tartaricacid.touhoulittlemaid.api.event;

import cn.sh1rocu.touhoulittlemaid.api.event.CancellableEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import javax.annotation.Nonnegative;
import java.util.List;

public class MaidFishedEvent extends CancellableEvent {
    private final EntityMaid maid;
    private final class_2371<class_1799> drops = class_2371.method_10211();
    private final MaidFishingHook hook;
    private int rodDamage;

    public MaidFishedEvent(List<class_1799> drops, int rodDamage, MaidFishingHook hook) {
        this.maid = hook.getMaidOwner();
        this.drops.addAll(drops);
        this.rodDamage = rodDamage;
        this.hook = hook;
    }

    public void damageRodBy(@Nonnegative int rodDamage) {
        this.rodDamage = rodDamage;
    }

    public EntityMaid getMaid() {
        return maid;
    }

    public class_2371<class_1799> getDrops() {
        return drops;
    }

    public MaidFishingHook getHook() {
        return hook;
    }

    public int getRodDamage() {
        return rodDamage;
    }

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.post(event);
        }
    });

    public interface Callback {
        void post(MaidFishedEvent event);
    }
}
