package com.github.tartaricacid.touhoulittlemaid.api.event;

import cn.sh1rocu.touhoulittlemaid.api.event.CancellableEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1665;
import net.minecraft.class_1799;

public abstract class MaidPickupEvent extends CancellableEvent {
    private final EntityMaid maid;
    private final boolean simulate;
    private boolean canPickup = false;

    public static final Event<ItemResultPre.Callback> ITEM_RESULT_PRE = EventFactory.createArrayBacked(ItemResultPre.Callback.class, callbacks -> event -> {
        for (ItemResultPre.Callback callback : callbacks) {
            callback.onItemResultPre(event);
        }
    });
    public static final Event<ItemResultPost.Callback> ITEM_RESULT_POST = EventFactory.createArrayBacked(ItemResultPost.Callback.class, callbacks -> event -> {
        for (ItemResultPost.Callback callback : callbacks) {
            callback.onItemResultPost(event);
        }
    });
    public static final Event<ExperienceResult.Callback> EXPERIENCE_RESULT = EventFactory.createArrayBacked(ExperienceResult.Callback.class, callbacks -> event -> {
        for (ExperienceResult.Callback callback : callbacks) {
            callback.onExperienceResult(event);
        }
    });
    public static final Event<ArrowResult.Callback> ARROW_RESULT = EventFactory.createArrayBacked(ArrowResult.Callback.class, callbacks -> event -> {
        for (ArrowResult.Callback callback : callbacks) {
            callback.onArrowResult(event);
        }
    });
    public static final Event<PowerPointResult.Callback> POWERPOINT_RESULT = EventFactory.createArrayBacked(PowerPointResult.Callback.class, callbacks -> event -> {
        for (PowerPointResult.Callback callback : callbacks) {
            callback.onPowerPointResult(event);
        }
    });

    public MaidPickupEvent(EntityMaid maid, boolean simulate) {
        this.maid = maid;
        this.simulate = simulate;
    }

    public EntityMaid getMaid() {
        return maid;
    }

    public boolean isSimulate() {
        return simulate;
    }

    public boolean isCanPickup() {
        return canPickup;
    }

    public void setCanPickup(boolean canPickup) {
        this.canPickup = canPickup;
    }

    public static class ItemResultPre extends MaidPickupEvent {
        private final class_1542 entityItem;

        public ItemResultPre(EntityMaid maid, class_1542 entityItem, boolean simulate) {
            super(maid, simulate);
            this.entityItem = entityItem;
        }

        public class_1542 getEntityItem() {
            return entityItem;
        }

        public interface Callback {
            void onItemResultPre(ItemResultPre event);
        }
    }

    public static class ItemResultPost extends MaidPickupEvent {
        /**
         * 女仆捡起的物品，复制的对象
         */
        private final class_1799 pickupItem;

        public ItemResultPost(EntityMaid maid, class_1799 pickupItem) {
            super(maid, false);
            this.pickupItem = pickupItem;
        }

        public class_1799 getPickupItem() {
            return pickupItem;
        }

        public interface Callback {
            void onItemResultPost(ItemResultPost event);
        }
    }

    public static class ExperienceResult extends MaidPickupEvent {
        private final class_1303 experienceOrb;

        public ExperienceResult(EntityMaid maid, class_1303 experienceOrb, boolean simulate) {
            super(maid, simulate);
            this.experienceOrb = experienceOrb;
        }

        public class_1303 getExperienceOrb() {
            return experienceOrb;
        }

        public interface Callback {
            void onExperienceResult(ExperienceResult event);
        }
    }

    public static class ArrowResult extends MaidPickupEvent {
        private final class_1665 arrow;

        public ArrowResult(EntityMaid maid, class_1665 arrow, boolean simulate) {
            super(maid, simulate);
            this.arrow = arrow;
        }

        public class_1665 getArrow() {
            return arrow;
        }

        public interface Callback {
            void onArrowResult(ArrowResult event);
        }
    }

    public static class PowerPointResult extends MaidPickupEvent {
        private final EntityPowerPoint powerPoint;

        public PowerPointResult(EntityMaid maid, EntityPowerPoint powerPoint, boolean simulate) {
            super(maid, simulate);
            this.powerPoint = powerPoint;
        }

        public EntityPowerPoint getPowerPoint() {
            return powerPoint;
        }


        public interface Callback {
            void onPowerPointResult(PowerPointResult event);
        }
    }
}