package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_1309;
import net.minecraft.class_4051;
import net.minecraft.class_4140;
import net.minecraft.class_4215;
import net.minecraftforge.common.ForgeConfigSpec;

import java.util.List;
import java.util.Optional;

public interface IRangedAttackTask extends IAttackTask {
    /**
     * 可见性校验工具，来自于 Sensor
     */
    class_4051 TARGET_CONDITIONS = class_4051.method_36625();

    /**
     * 寻找第一个可见目标，使用独立的方法，区别于 IAttackTask
     *
     * @param maid 女仆
     * @return 第一个可视对象
     */
    static Optional<? extends class_1309> findFirstValidAttackTarget(EntityMaid maid) {
        // 先检查攻击女仆的对象
        class_1309 lastAttacker = maid.method_6065();
        if (lastAttacker != null && maid.method_18395(lastAttacker) && maid.canSee(lastAttacker)) {
            return Optional.of(lastAttacker);
        }
        // 再检查记忆中的可见对象
        var memory = maid.method_18868().method_18904(class_4140.field_18441);
        if (memory.isEmpty()) {
            return Optional.empty();
        }
        // 改回 for 循环，避免 stream 带来的额外开销
        for (class_1309 e : memory.get()) {
            if (maid.method_18395(e) && maid.canSee(e)) {
                return Optional.of(e);
            }
        }
        return Optional.empty();
    }

    /**
     * 依据配置文件和 TargetingConditions 来检验攻击目标是否符合条件
     *
     * @param maid        女仆
     * @param target      女仆将要攻击的对象
     * @param configRange 相关距离的配置文件
     * @return 能够攻击
     */
    static boolean targetConditionsTest(EntityMaid maid, class_1309 target, ForgeConfigSpec.IntValue configRange) {
        TARGET_CONDITIONS.method_18418(configRange.get());
        return TARGET_CONDITIONS.method_18419(maid, target);
    }

    /**
     * 执行射击动作
     *
     * @param shooter        射击者
     * @param target         射击目标
     * @param distanceFactor 距离因素，即弓箭的蓄力值
     */
    void performRangedAttack(EntityMaid shooter, class_1309 target, float distanceFactor);

    /**
     * 女仆是否能看到敌人
     * <p>
     * 因为原版默认的攻击识别范围是固定死的 16 格，但是一些远程武器我们希望获得超视距打击
     * 通过修改此处来获得更远的攻击距离
     *
     * @param maid   女仆
     * @param target 攻击目标
     * @return 是否在可视范围内
     */
    default boolean canSee(EntityMaid maid, class_1309 target) {
        return class_4215.method_24565(maid, target);
    }
}
