package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemMaidBeacon;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenBeaconGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_6088;
import net.minecraft.world.level.block.*;
import javax.annotation.Nullable;
import java.util.Locale;

public class BlockMaidBeacon extends class_2237 {
    public static final class_2754<Position> POSITION = class_2754.method_11850("position", Position.class);
    private static final class_265 UP_AABB = class_2248.method_9541(3, 1, 3, 13, 16, 13);
    private static final class_265 DOWN_AABB = class_2248.method_9541(6.5, 0, 6.5, 9.5, 26, 9.5);

    public BlockMaidBeacon() {
        super(class_2251.method_9637().method_9626(class_2498.field_11547).method_9629(2, 2).method_22488().method_50012(class_3619.field_15972)
                .method_9631(s -> s.method_11654(POSITION) == Position.DOWN ? 0 : 15));
        this.method_9590(this.field_10647.method_11664().method_11657(POSITION, Position.DOWN));
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (state.method_11654(BlockMaidBeacon.POSITION) != Position.DOWN) {
            return new TileEntityMaidBeacon(pos, state);
        }
        return null;
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return level.method_8608() ? null : method_31618(type, TileEntityMaidBeacon.TYPE, TileEntityMaidBeacon::serverTick);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        if (worldIn.method_8321(pos) instanceof TileEntityMaidBeacon) {
            if (!worldIn.field_9236) {
                ServerPlayNetworking.send((class_3222) player, OpenBeaconGuiMessage.ID, OpenBeaconGuiMessage.encode(pos));
            }
            return class_1269.method_29236(worldIn.field_9236);
        }
        return super.method_9534(state, worldIn, pos, player, handIn, hit);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        Position position = state.method_11654(POSITION);
        return position == Position.DOWN ? DOWN_AABB : UP_AABB;
    }

    @Override
    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        if (facing.method_10166() == class_2350.class_2351.field_11052) {
            Position position = stateIn.method_11654(POSITION);
            if (position == Position.DOWN && facing == class_2350.field_11036) {
                if (!facingState.method_27852(this) || facingState.method_11654(POSITION) == Position.DOWN) {
                    return class_2246.field_10124.method_9564();
                }
            }
            if (position != Position.DOWN && facing == class_2350.field_11033) {
                if (!facingState.method_27852(this) || facingState.method_11654(POSITION) == Position.UP_W_E || facingState.method_11654(POSITION) == Position.UP_N_S) {
                    return class_2246.field_10124.method_9564();
                }
            }
        }
        return super.method_9559(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public void method_9576(class_1937 worldIn, class_2338 pos, class_2680 state, class_1657 player) {
        if (!worldIn.field_9236 && player.method_7337()) {
            Position position = state.method_11654(POSITION);
            if (position != Position.DOWN) {
                class_2338 belowPos = pos.method_10074();
                class_2680 belowState = worldIn.method_8320(belowPos);
                if (belowState.method_27852(this) && belowState.method_11654(POSITION) == Position.DOWN) {
                    worldIn.method_8652(belowPos, class_2246.field_10124.method_9564(), class_2248.field_31036 | class_2248.field_31032);
                    worldIn.method_8444(player, class_6088.field_31144, belowPos, class_2248.method_9507(belowState));
                }
            }
        }
        super.method_9576(worldIn, pos, state, player);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 newState, boolean isMoving) {
        class_2586 te = worldIn.method_8321(pos);
        if (te instanceof TileEntityMaidBeacon) {
            method_9577(worldIn, pos, ItemMaidBeacon.tileEntityToItemStack((TileEntityMaidBeacon) te));
        }
        super.method_9536(state, worldIn, pos, newState, isMoving);
    }

    @Override
    //public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull Player player) {
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return new class_1799(InitItems.MAID_BEACON);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2338 blockpos = context.method_8037();
        class_1937 world = context.method_8045();
        int maxHeight = world.method_31600() - 1;
        if (blockpos.method_10264() < maxHeight && world.method_8320(blockpos.method_10084()).method_26166(context)) {
            return super.method_9605(context);
        }
        return null;
    }

    @Override
    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2350 facing = getHorizontalDirection(placer);
        class_2680 stateUp;
        if (facing == class_2350.field_11035 || facing == class_2350.field_11043) {
            stateUp = this.method_9564().method_11657(BlockMaidBeacon.POSITION, Position.UP_N_S);
        } else {
            stateUp = this.method_9564().method_11657(BlockMaidBeacon.POSITION, Position.UP_W_E);
        }
        worldIn.method_8652(pos.method_10084(), stateUp, class_2248.field_31036);
        class_2586 te = worldIn.method_8321(pos.method_10084());
        if (te instanceof TileEntityMaidBeacon tileEntityMaidBeacon) {
            ItemMaidBeacon.itemStackToTileEntity(stack, tileEntityMaidBeacon);
            tileEntityMaidBeacon.refresh();
        }
    }

    @Override
    public class_2680 method_9598(class_2680 state, /*LevelAccessor world, BlockPos pos,*/ class_2470 direction) {
        switch (direction) {
            case field_11463:
            case field_11465:
                if (state.method_11654(POSITION) == Position.UP_N_S) {
                    return state.method_11657(POSITION, Position.UP_W_E);
                }
                if (state.method_11654(POSITION) == Position.UP_W_E) {
                    return state.method_11657(POSITION, Position.UP_N_S);
                }
                return state;
            default:
                return state;
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(POSITION);
    }

    private class_2350 getHorizontalDirection(@Nullable class_1309 placer) {
        return placer == null ? class_2350.field_11043 : placer.method_5735();
    }

    public enum Position implements class_3542 {
        // Beacon State
        UP_N_S, UP_W_E, DOWN;

        @Override
        public String method_15434() {
            return this.name().toLowerCase(Locale.US);
        }

        @Override
        public String toString() {
            return method_15434();
        }
    }
}
