package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang;

import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.*;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.variable.LadderFacingVariable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.binding.ContextBinding;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.EmptyFunction;
import com.github.tartaricacid.touhoulittlemaid.util.EquipmentUtil;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_638;
import org.apache.commons.lang3.StringUtils;

public class YSMBinding extends ContextBinding {
    public static final YSMBinding INSTANCE = new YSMBinding();

    @SuppressWarnings("resource")
    private YSMBinding() {
        function("mod_version", new ModVersion());
        function("equipped_enchantment_level", new EquippedEnchantmentLevel());
        function("effect_level", new EffectLevel());
        function("relative_block_name", new RelativeBlockName());

        function("bone_rot", new BoneRotation());
        function("bone_pos", new BonePosition());
        function("bone_scale", new BoneScale());

        var("head_yaw", ctx -> ctx.data().netHeadYaw);
        var("head_pitch", ctx -> ctx.data().headPitch);
        var("weather", ctx -> getWeather(ctx.level()));
        var("dimension_name", ctx -> ctx.level().method_27983().method_29177().toString());
        var("fps", ctx -> class_310.method_1551().method_47599());

        entityVar("is_passenger", ctx -> ctx.entity().method_5765());
        entityVar("is_sleep", ctx -> ctx.entity().method_18376() == class_4050.field_18078);
        entityVar("is_sneak", ctx -> ctx.entity().method_24828() && ctx.entity().method_18376() == class_4050.field_18081);
        entityVar("is_open_air", ctx -> isOpenAir(ctx.entity()));
        entityVar("eye_in_water", ctx -> ctx.entity().method_5869());
        entityVar("frozen_ticks", ctx -> ctx.entity().method_32312());
        entityVar("air_supply", ctx -> ctx.entity().method_5669());

        livingEntityVar("has_helmet", ctx -> getSlotValue(ctx.entity(), class_1304.field_6169));
        livingEntityVar("has_chest_plate", ctx -> getSlotValue(ctx.entity(), class_1304.field_6174));
        livingEntityVar("has_leggings", ctx -> getSlotValue(ctx.entity(), class_1304.field_6172));
        livingEntityVar("has_boots", ctx -> getSlotValue(ctx.entity(), class_1304.field_6166));
        livingEntityVar("has_mainhand", ctx -> getSlotValue(ctx.entity(), class_1304.field_6173));
        livingEntityVar("has_offhand", ctx -> getSlotValue(ctx.entity(), class_1304.field_6171));
        livingEntityVar("has_elytra", ctx -> !EquipmentUtil.getEquippedElytraItem(ctx.entity()).method_7960());
        livingEntityVar("is_riptide", ctx -> ctx.entity().method_6123());
        livingEntityVar("armor_value", ctx -> ctx.entity().method_6096());
        livingEntityVar("hurt_time", ctx -> ctx.entity().field_6235);
        livingEntityVar("is_close_eyes", ctx -> getEyeCloseState(ctx.animationEvent(), ctx.entity()));
        livingEntityVar("on_ladder", ctx -> ctx.entity().method_6101());
        livingEntityVar("ladder_facing", new LadderFacingVariable());
        livingEntityVar("arrow_count", ctx -> ctx.entity().method_6022());
        livingEntityVar("stinger_count", ctx -> ctx.entity().method_21753());

        livingEntityVar("attack_damage", ctx -> ctx.entity().method_26825(class_5134.field_23721));
        livingEntityVar("attack_speed", ctx -> ctx.entity().method_26825(class_5134.field_23723));
        livingEntityVar("attack_knockback", ctx -> ctx.entity().method_26825(class_5134.field_23722));
        livingEntityVar("movement_speed", ctx -> ctx.entity().method_26825(class_5134.field_23719));
        livingEntityVar("knockback_resistance", ctx -> ctx.entity().method_26825(class_5134.field_23718));
        livingEntityVar("luck", ctx -> ctx.entity().method_26825(class_5134.field_23726));

        livingEntityVar("block_reach", ctx -> ctx.entity().method_26825(ReachEntityAttributes.REACH));
        livingEntityVar("entity_reach", ctx -> ctx.entity().method_26825(ReachEntityAttributes.REACH));
        // livingEntityVar("swim_speed", ctx -> ctx.entity().getAttributeValue(NeoForgeMod.SWIM_SPEED));
        // livingEntityVar("entity_gravity", ctx -> ctx.entity().getAttributeValue(Attributes.GRAVITY));
        // livingEntityVar("step_height_addition", ctx -> ctx.entity().getAttributeValue(Attributes.STEP_HEIGHT) - 0.6);
        // livingEntityVar("nametag_distance", ctx -> ctx.entity().getAttributeValue(NeoForgeMod.NAMETAG_DISTANCE));


        // 女仆和 YSM 之间不一致的 molang，仅保留防止报错
        function("dump_equipped_item", new EmptyFunction());
        function("dump_relative_block", new EmptyFunction());
        function("bone_pivot_abs", new EmptyFunction());

        var("dump_mods", ctx -> 0);
        var("texture_name", ctx -> StringUtils.EMPTY);
        var("elytra_rot_x", ctx -> 0);
        var("elytra_rot_y", ctx -> 0);
        var("elytra_rot_z", ctx -> 0);

        entityVar("dump_effects", ctx -> 0);
        entityVar("dump_biome", ctx -> 0);
        entityVar("biome_category", ctx -> 0);

        livingEntityVar("rendering_in_inventory", ctx -> false);
        maidEntityVar("food_level", ctx -> 20);

        var("first_person_mod_hide", ctx -> false);
        var("has_left_shoulder_parrot", ctx -> false);
        var("has_right_shoulder_parrot", ctx -> false);
        var("left_shoulder_parrot_variant", ctx -> 0);
        var("right_shoulder_parrot_variant", ctx -> 0);
    }

    private static boolean getEyeCloseState(AnimationEvent<?> animationEvent, class_1309 player) {
        double remainder = (animationEvent.getAnimationTick() + Math.abs(player.method_5667().getLeastSignificantBits()) % 10) % 90;
        boolean isBlinkTime = 85 < remainder && remainder < 90;
        return player.method_6113() || isBlinkTime;
    }

    private static boolean getSlotValue(class_1309 entity, class_1304 slot) {
        return !EquipmentUtil.getEquippedItem(entity, slot).method_7960();
    }

    private static int getWeather(class_638 world) {
        if (world.method_8546()) {
            return 2;
        } else if (world.method_8419()) {
            return 1;
        }
        return 0;
    }

    private static boolean isOpenAir(class_1297 entity) {
        class_2338 blockpos = entity.method_24515();
        if (!entity.field_6002.method_8311(blockpos)) {
            return false;
        }
        return entity.field_6002.method_8598(class_2902.class_2903.field_13197, blockpos).method_10264() <= blockpos.method_10264();
    }
}
