package com.github.tartaricacid.touhoulittlemaid.client.gui.sound;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.SoundElementButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.SoundPackButton;
import com.github.tartaricacid.touhoulittlemaid.client.sound.CustomSoundLoader;
import com.github.tartaricacid.touhoulittlemaid.client.sound.data.MaidSoundInstance;
import com.github.tartaricacid.touhoulittlemaid.client.sound.data.SoundData;
import com.github.tartaricacid.touhoulittlemaid.client.sound.pojo.SoundPackInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetMaidSoundIdMessage;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_4068;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MaidSoundPackGui extends class_437 {
    private static final class_2960 ICON = new class_2960(TouhouLittleMaid.MOD_ID, "textures/gui/maid_custom_sound.png");
    private final int packPerSize = 4;
    private final int soundPerSize = 13;
    private final EntityMaid maid;
    private String selectSoundId = null;
    private int startX;
    private int startY;
    private int packPage = 0;
    private int soundPage = 0;
    private int packMaxPage = 0;
    private int soundMaxPage = 0;

    public MaidSoundPackGui(EntityMaid maid) {
        super(class_2561.method_43470("Maid Custom Sound Pack GUI"));
        this.maid = maid;
    }

    @Override
    protected void method_25426() {
        this.method_37067();

        this.startX = (field_22789 - 400) / 2;
        this.startY = (field_22790 - 220) / 2;
        this.packMaxPage = (CustomSoundLoader.CACHE.size() - 1) / packPerSize;
        this.soundMaxPage = 0;

        this.addSoundPackButtons();
        this.addPackPageButtons();
        if (StringUtils.isNotBlank(selectSoundId) && CustomSoundLoader.CACHE.containsKey(selectSoundId)) {
            this.addSoundElementButtons();
            this.addSoundOtherButtons();
            this.addSoundElementPageButtons();
        }
    }

    private void addPackPageButtons() {
        this.method_37063(new FlatColorButton(startX + 5, startY + 201, 32, 16, class_2561.method_43470("<"), (b) -> {
            if (this.packPage > 0) {
                packPage--;
                this.method_25426();
            }
        }));

        this.method_37063(new FlatColorButton(startX + 203, startY + 201, 32, 16, class_2561.method_43470(">"), (b) -> {
            if ((packPage + 1) * packPerSize < CustomSoundLoader.CACHE.size()) {
                packPage++;
                this.method_25426();
            }
        }));
    }

    private void addSoundElementButtons() {
        int yOffset = 41;
        boolean otherColor = false;
        Map<class_2960, List<SoundData>> buffers = CustomSoundLoader.getSoundCache(selectSoundId).buffers();
        List<class_2960> soundIds = List.copyOf(buffers.keySet());
        this.soundMaxPage = (buffers.size() - 1) / soundPerSize;
        int startSoundIndex = soundPage * soundPerSize;
        if (startSoundIndex >= soundIds.size()) {
            this.soundPage = 0;
            startSoundIndex = 0;
        }
        int endSoundIndex = Math.min(soundIds.size(), startSoundIndex + soundPerSize);
        for (int i = startSoundIndex; i < endSoundIndex; i++) {
            class_2960 soundEvent = soundIds.get(i);
            this.method_37063(new SoundElementButton(startX + 245, startY + yOffset, 152, 12, soundEvent, buffers.get(soundEvent), otherColor, (b) -> {
                SoundElementButton soundButton = (SoundElementButton) b;
                class_3414 event = class_7923.field_41172.method_10223(soundButton.getSoundEvent());
                if (field_22787 != null && event != null) {
                    field_22787.method_1483().method_4873(new MaidSoundInstance(event, this.selectSoundId, this.maid, true));
                }
            }).setTooltips("tooltips.touhou_little_maid.custom_sound.play_sound"));
            otherColor = !otherColor;
            yOffset += 12;
        }
    }

    private void addSoundOtherButtons() {
        this.method_37063(new FlatColorButton(startX + 245, startY + 19, 110, 18, class_2561.method_43471("gui.touhou_little_maid.custom_sound.pack.apply"), (b) -> {
            if (StringUtils.isNotBlank(selectSoundId) && CustomSoundLoader.CACHE.containsKey(selectSoundId)) {
                this.maid.setSoundPackId(this.selectSoundId);
                ClientPlayNetworking.send(SetMaidSoundIdMessage.ID, SetMaidSoundIdMessage.encode(this.maid.method_5628(), this.selectSoundId));
                this.method_25426();
            }
        }));

        this.method_37063(new FlatColorButton(startX + 358, startY + 19, 18, 18, class_2561.method_43473(), (b) -> {
            if (StringUtils.isNotBlank(selectSoundId) && CustomSoundLoader.CACHE.containsKey(selectSoundId)) {
                String url = CustomSoundLoader.getSoundCache(selectSoundId).info().getUrl();
                if (StringUtils.isNotBlank(url) && field_22787 != null) {
                    field_22787.method_1507(new class_407(yes -> {
                        if (yes) {
                            class_156.method_668().method_670(url);
                        }
                        field_22787.method_1507(this);
                    }, url, false));
                }
            }
        }).setTooltips("tooltips.touhou_little_maid.custom_sound.open_url"));

        this.method_37063(new FlatColorButton(startX + 379, startY + 19, 18, 18, class_2561.method_43473(), (b) -> {
            if (field_22787 != null) {
                field_22787.method_1483().method_4873(new MaidSoundInstance(InitSounds.MAID_CREDIT, this.selectSoundId, this.maid, true));
            }
        }).setTooltips("tooltips.touhou_little_maid.custom_sound.credit"));
    }

    private void addSoundElementPageButtons() {
        this.method_37063(new FlatColorButton(startX + 245, startY + 201, 16, 16, class_2561.method_43470("<"), (b) -> {
            if (this.soundPage > 0) {
                soundPage--;
                this.method_25426();
            }
        }));

        this.method_37063(new FlatColorButton(startX + 381, startY + 201, 16, 16, class_2561.method_43470(">"), (b) -> {
            if (StringUtils.isNotBlank(selectSoundId) && CustomSoundLoader.CACHE.containsKey(selectSoundId)) {
                Map<class_2960, List<SoundData>> buffersIn = CustomSoundLoader.getSoundCache(selectSoundId).buffers();
                if ((soundPage + 1) * soundPerSize < buffersIn.size()) {
                    soundPage++;
                    this.method_25426();
                }
            }
        }));
    }

    private void addSoundPackButtons() {
        int yOffset = 19;
        List<String> soundPackIds = new ArrayList<>(CustomSoundLoader.CACHE.keySet());
        int startPackIndex = packPage * packPerSize;
        if (startPackIndex >= soundPackIds.size()) {
            this.packPage = 0;
            startPackIndex = 0;
        }
        int endPackIndex = Math.min(soundPackIds.size(), startPackIndex + packPerSize);
        for (int i = startPackIndex; i < endPackIndex; i++) {
            String soundId = soundPackIds.get(i);
            SoundPackInfo info = CustomSoundLoader.getSoundCache(soundId).info();
            SoundPackButton button = new SoundPackButton(startX + 5, startY + yOffset, info, b -> {
                this.selectSoundId = soundId;
                this.soundPage = 0;
                this.method_25426();
            });
            if (StringUtils.isNotBlank(info.getDescription())) {
                class_5250 description = ParseI18n.parse(info.getDescription());
                button.setTooltips(Collections.singletonList(description));
            }
            if (soundId.equals(selectSoundId)) {
                button.setSelect(true);
            }
            if (soundId.equals(this.maid.getSoundPackId())) {
                button.setUse(true);
            }
            this.method_37063(button);
            yOffset += 45;
        }
    }

    @Override
    public void method_25394(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.method_25420(graphics);
        graphics.method_25294(startX, startY, startX + 240, startY + 220, 0xFF2A2A2A);
        graphics.method_25294(startX + 242, startY, startX + 400, startY + 220, 0xFF2A2A2A);
        graphics.method_27534(field_22793, class_2561.method_43471("gui.touhou_little_maid.custom_sound.pack.title"), startX + 120, startY + 6, 0xFFFFFF);
        graphics.method_27534(field_22793, class_2561.method_43471("gui.touhou_little_maid.custom_sound.sounds.preview"), startX + 321, startY + 6, 0xFFFFFF);
        graphics.method_25300(field_22793, String.format("%d/%d", packPage + 1, packMaxPage + 1), startX + 120, startY + 206, 0xBBBBBB);
        for (class_4068 renderable : ((ScreenAccessor) this).tlm$getRenderables()) {
            renderable.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
        }
        if (StringUtils.isNotBlank(selectSoundId) && CustomSoundLoader.CACHE.containsKey(selectSoundId)) {
            graphics.method_25300(field_22793, String.format("%d/%d", soundPage + 1, soundMaxPage + 1), startX + 321, startY + 206, 0xBBBBBB);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture(0, ICON);
            graphics.method_25290(ICON, startX + 359, startY + 20, 0, 0, 16, 16, 256, 256);
            graphics.method_25290(ICON, startX + 380, startY + 20, 16, 0, 16, 16, 256, 256);
        }
        ((ScreenAccessor) this).tlm$getRenderables().stream().filter(b -> b instanceof FlatColorButton).forEach(b -> ((FlatColorButton) b).renderToolTip(graphics, this, pMouseX, pMouseY));
    }
}
