package com.github.tartaricacid.touhoulittlemaid.client.model;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockModelPOJO;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_1308;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;

public class EasterEggModel extends BedrockModel<class_1308> {
    private static final class_2960 MODEL = new class_2960(TouhouLittleMaid.MOD_ID, "models/bedrock/entity/easter_egg_model.json");
    private static final class_2960 TEXTURE = new class_2960(TouhouLittleMaid.MOD_ID, "textures/bedrock/entity/easter_egg_model.png");
    private static EasterEggModel INSTANCE;
    private static MaidModelInfo INFO;

    public EasterEggModel() {
        class_3300 manager = class_310.method_1551().method_1478();
        try (InputStream stream = manager.open(MODEL)) {
            loadLegacyModel(CustomPackLoader.GSON.fromJson(new InputStreamReader(stream, StandardCharsets.UTF_8), BedrockModelPOJO.class));
        } catch (IOException exception) {
            TouhouLittleMaid.LOGGER.error("Failed to load easter egg model", exception);
        }
        this.modelMap.forEach((key, model) -> modelMapWrapper.put(key, new ModelRendererWrapper(model)));
    }

    public static EasterEggModel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EasterEggModel();
        }
        return INSTANCE;
    }

    public static MaidModelInfo getInfo() {
        if (INFO == null) {
            INFO = new MaidModelInfo() {
                @Override
                public class_2960 getTexture() {
                    return TEXTURE;
                }
            };
        }
        return INFO;
    }
}