package com.github.tartaricacid.touhoulittlemaid.compat.ironchest;

import anner.ironchest.blocks.blockentities.GenericChestEntity;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IChestType;
import com.github.tartaricacid.touhoulittlemaid.inventory.chest.ChestManager;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2586;

public final class IronChestType implements IChestType {
    private static final String IRON_CHEST_ID = "ironchest";

    public static void register(ChestManager manager) {
        if (FabricLoader.getInstance().isModLoaded(IRON_CHEST_ID)) {
            manager.add(new IronChestType());
        }
    }

    @Override
    public boolean isChest(class_2586 chest) {
        if (FabricLoader.getInstance().isModLoaded(IRON_CHEST_ID)) {
            return chest instanceof GenericChestEntity;
        }
        return false;
    }

    @Override
    public boolean canOpenByPlayer(class_2586 chest, class_1657 player) {
        if (FabricLoader.getInstance().isModLoaded(IRON_CHEST_ID) && chest instanceof GenericChestEntity ironChestBlock) {
            return ironChestBlock.method_17489(player);
        }
        return false;
    }

    @Override
    public int getOpenCount(class_1922 level, class_2338 pos, class_2586 chest) {
        if (FabricLoader.getInstance().isModLoaded(IRON_CHEST_ID) && chest instanceof GenericChestEntity) {
            return GenericChestEntity.method_11048(level, pos);
        }
        return DENY_COUNT;
    }
}
