package com.github.tartaricacid.touhoulittlemaid.entity.backpack;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.BigBackpackContainer;
import com.github.tartaricacid.touhoulittlemaid.item.BackpackLevel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_4587;
import net.minecraft.class_5599;
import net.minecraft.class_583;
import javax.annotation.Nullable;

import static com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader.BIG_BACKPACK;

public class BigBackpack extends IMaidBackpack {
    public static final class_2960 ID = new class_2960(TouhouLittleMaid.MOD_ID, "big_backpack");

    @Override
    public void onPutOn(class_1799 stack, class_1657 player, EntityMaid maid) {
    }

    @Override
    public void onTakeOff(class_1799 stack, class_1657 player, EntityMaid maid) {
        dropRelativeItems(stack, maid);
    }

    @Override
    public void onSpawnTombstone(EntityMaid maid, EntityTombstone tombstone) {
    }

    @Override
    public class_3908 getGuiProvider(int entityId) {
        return new ExtendedScreenHandlerFactory() {
            @Override
            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                buf.writeInt(entityId);
            }

            @Override
            public class_2561 method_5476() {
                return class_2561.method_43470("Maid Big Container");
            }

            @Override
            public AbstractMaidContainer createMenu(int index, class_1661 playerInventory, class_1657 player) {
                return new BigBackpackContainer(index, playerInventory, entityId);
            }

            @Override
            public boolean shouldCloseCurrentScreen() {
                return false;
            }

/*            @Override
            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }*/
        };
    }

    @Override
    public int getAvailableMaxContainerIndex() {
        return BackpackLevel.BIG_CAPACITY;
    }

    @Nullable
    @Override
    @Environment(EnvType.CLIENT)
    public class_583<EntityMaid> getBackpackModel(class_5599 modelSet) {
        return BedrockModelLoader.getModel(BIG_BACKPACK);
    }

    @Nullable
    @Override
    @Environment(EnvType.CLIENT)
    public class_2960 getBackpackTexture() {
        return new class_2960(TouhouLittleMaid.MOD_ID, "textures/bedrock/entity/backpack/big_backpack.png");
    }

    @Environment(EnvType.CLIENT)
    @Override
    public void offsetBackpackItem(class_4587 poseStack) {
        poseStack.method_22904(0, 0.25, -0.25);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public class_1792 getItem() {
        return InitItems.MAID_BACKPACK_BIG;
    }
}
