package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import net.minecraft.class_2338;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class MaidSwimManager {
    /**
     * 游泳碰撞箱
     */
    private static final class_4048 SWIMMING_DIMENSIONS = class_4048.method_18384(0.6F, 0.6F);
    private final EntityMaid maid;
    /**
     * 正在食用可提供水下呼吸的食物标志位
     */
    private boolean isEatBreatheItem = false;
    /**
     * 主动游泳标志位
     */
    private boolean wantToSwim = false;

    /**
     * 游泳目标点，控制视角用
     */
    private class_2338 swimTarget = null;
    /**
     * 是否已经准备登陆，登陆时基于额外的加速度
     */
    private boolean readyToLand = false;
    /**
     * 是否准备前去呼吸，用于屏蔽距离传送
     */
    private boolean isGoingToBreath = false;


    public MaidSwimManager(EntityMaid maid) {
        this.maid = maid;
        maid.method_5941(class_7.field_18, 0.0F);
    }

    /**
     * 重置状态，从而控制饮用药水
     */
    public void resetEatBreatheItem() {
        if (this.isEatBreatheItem) {
            this.isEatBreatheItem = false;
        }
    }

    /**
     * 依据游泳状态，切换成游泳的寻路
     */
    public void updateSwimming() {
        if (!maid.field_6002.field_9236) {
            this.updatePose();
        }
    }

    /**
     * 更新游泳姿势同时更新碰撞箱
     */
    private void updatePose() {
        if (this.wantToSwim() && !maid.method_24828() && !maid.isMaidInSittingPose() && !maid.method_5765()) {
            maid.method_5796(true);
            maid.method_18380(class_4050.field_18079);
        } else {
            maid.method_5796(false);
            // 也许有更好的方式?
            if (!maid.method_6113()) {
                maid.method_18380(class_4050.field_18076);
            }
        }
    }

    public void setWantToSwim(boolean pSearchingForLand) {
        this.wantToSwim = pSearchingForLand;
    }

    public boolean wantToSwim() {
        return this.wantToSwim;
    }

    public boolean isEatBreatheItem() {
        return isEatBreatheItem;
    }

    public void setEatBreatheItem(boolean eatBreatheItem) {
        isEatBreatheItem = eatBreatheItem;
    }

    public class_4048 getSwimmingDimensions() {
        return SWIMMING_DIMENSIONS;
    }

    public void setSwimTarget(class_2338 pos) {
        this.swimTarget = pos;
    }

    @Nullable
    public class_2338 getSwimTarget() {
        if (!wantToSwim()) {
            return null;
        }
        return swimTarget;
    }

    public void setReadyToLand(boolean readyToLand) {
        this.readyToLand = readyToLand;
    }

    public boolean isReadyToLand() {
        return readyToLand;
    }

    public void setGoingToBreath(boolean goingToBreath) {
        isGoingToBreath = goingToBreath;
    }

    public boolean isGoingToBreath() {
        return isGoingToBreath;
    }
}