package com.github.tartaricacid.touhoulittlemaid.init;

import cn.sh1rocu.touhoulittlemaid.api.extension.ILootTableBuilder;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.datagen.LootTableGenerator;
import com.github.tartaricacid.touhoulittlemaid.loot.RandomBoardStateFunction;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_5339;
import net.minecraft.class_55;
import net.minecraft.class_7923;
import net.minecraft.class_83;

public class InitLootModifier {
    private static final class_2960 LAST = new class_2960(TouhouLittleMaid.MOD_ID, "last");

    public static class_5339 BOARD_STATE_RANDOMLY = registerFunction("board_state_randomly", new class_5339(new RandomBoardStateFunction.Serializer()));

    private static class_5339 registerFunction(String name, class_5339 function) {
        return class_2378.method_10230(class_7923.field_41134, new class_2960(TouhouLittleMaid.MOD_ID, name), function);
    }

    public static void init() {
        // Global Modifier
        LootTableEvents.MODIFY.register((resourceManager, lootManager, key, builder, source) -> {
                    if (key.toString().startsWith("minecraft:chests"))
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.CHEST_POWER_POINT)));

                    if (key == class_39.field_850)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.SPAWN_BONUS)));
                    if (key == class_39.field_17109)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.NORMAL_BAUBLE)));
                    if (key == class_39.field_16751)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.RANDOM_BOARD_STATE)));
                    if (key == class_39.field_885)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.RARE_BAUBLE)));
                    if (key == class_39.field_803)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.RARE_BAUBLE)));
                    if (key == class_39.field_484)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.VERY_RARE_BAUBLE)));
                    if (key == class_39.field_356)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.FURNACE_OR_CRAFTING_TABLE_BACKPACK)));
                    if (key == class_39.field_472)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.NORMAL_BACKPACK)));
                    if (key == class_39.field_615)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.TANK_BACKPACK)));
                    if (key == class_39.field_842)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.ENDER_CHEST_BACKPACK)));
                    if (key == class_39.field_683)
                        builder.method_336(class_55.method_347()
                                .method_351(class_83.method_428(LootTableGenerator.SHRINE_LESS))
                                .method_351(class_83.method_428(LootTableGenerator.RANDOM_BOARD_STATE)));
                    if (key == class_39.field_38438)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.SHRINE_LESS)));
                    if (key == class_39.field_24046)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.SHRINE_LESS)));
                    if (key == class_39.field_274)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.SHRINE_MORE)));

                    if (key == class_39.field_251)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.MAID_BURIED_TREASURE)));

                    if (key == class_39.field_16593)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.STRUCTURE_SPAWN_MAID_GIFT)));
                    if (key == class_39.field_484)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.STRUCTURE_SPAWN_MAID_GIFT)));

                    if (key == class_39.field_266)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.FISHING_POWER_POINT)));
                }
        );

        LootTableEvents.MODIFY.addPhaseOrdering(Event.DEFAULT_PHASE, LAST);
        LootTableEvents.MODIFY.register(LAST,
                (resourceManager, lootManager, key, builder, source) -> ((ILootTableBuilder) builder).tlm$setId(key)
        );
    }
}
