package com.github.tartaricacid.touhoulittlemaid.init.registry;

import cn.sh1rocu.touhoulittlemaid.api.event.PotentialSpawnsEvent;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5483;

import static com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig.MAID_FAIRY_BLACKLIST_DIMENSION;

public final class MobSpawnInfoRegistry {
    private static class_5483.class_1964 SPAWNER_DATA;

    public static void addMobSpawnInfo(PotentialSpawnsEvent event) {
        if (event.getLevel() instanceof class_3218 level) {
            int spawnProbability = MiscConfig.MAID_FAIRY_SPAWN_PROBABILITY.get();
            if (spawnProbability <= 0) {
                // 优先判断等于 0 的情况，减少性能消耗
                return;
            }
            class_2960 dimension = level.method_27983().method_29177();
            if (event.getMobCategory() == class_1311.field_6302 && dimensionIsOkay(dimension)) {
                List<class_5483.class_1964> spawnerData = event.getSpawnerDataList();
                boolean canZombieSpawn = spawnerData.stream().anyMatch(data -> data.field_9389.equals(class_1299.field_6051));
                if (SPAWNER_DATA == null || SPAWNER_DATA.method_34979().method_34976() != spawnProbability) {
                    SPAWNER_DATA = new class_5483.class_1964(InitEntities.FAIRY, spawnProbability, 2, 4);
                }
                if (canZombieSpawn) {
                    event.addSpawnerData(SPAWNER_DATA);
                }
            }
        }
    }

    private static boolean dimensionIsOkay(class_2960 id) {
        return !MAID_FAIRY_BLACKLIST_DIMENSION.get().contains(id.toString());
    }
}
