package com.github.tartaricacid.touhoulittlemaid.inventory.handler;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;

public class MaidBackpackHandler extends ItemStackHandler {
    public static final int BACKPACK_ITEM_SLOT = 5;
    private final EntityMaid maid;

    public MaidBackpackHandler(int size, EntityMaid maid) {
        super(size);
        this.maid = maid;
    }

    @Override
    public boolean isItemValid(int slot, @Nonnull class_1799 stack) {
        return EntityMaid.canInsertItem(stack);
    }

    @Override
    protected void onContentsChanged(int slot) {
        if (slot == BACKPACK_ITEM_SLOT) {
            maid.setBackpackShowItem(this.getStackInSlot(slot));
        }
    }
}
