package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.client.gui.item.ServantBellSetScreen;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5244;
import org.apache.commons.lang3.tuple.Pair;

import javax.annotation.Nullable;
import java.util.List;
import java.util.UUID;

public class ItemServantBell extends class_1792 {
    private static final String UUID_TAG = "ServantBellUuid";
    private static final String TIP_TAG = "ServantBellTip";
    private static final String SHOW_TAG = "ServantBellShow";
    private static final String SHOW_DIMENSION_TAG = "Dimension";
    private static final String SHOW_POS_TAG = "Pos";
    private static final int MIN_USE_DURATION = 20;

    public ItemServantBell() {
        super((new class_1793().method_7889(1)));
    }

    public static void recordMaidInfo(class_1799 stack, UUID uuid, String tip) {
        if (stack.method_31574(InitItems.SERVANT_BELL)) {
            class_2487 tag = stack.method_7948();
            tag.method_25927(UUID_TAG, uuid);
            tag.method_10582(TIP_TAG, tip);
        }
    }

    @Nullable
    public static Pair<String, class_2338> getMaidShow(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573(SHOW_TAG, class_2520.field_33260)) {
            class_2487 showTag = tag.method_10562(SHOW_TAG);
            if (showTag.method_10573(SHOW_DIMENSION_TAG, class_2520.field_33258) && showTag.method_10573(SHOW_POS_TAG, class_2520.field_33260)) {
                String dimension = showTag.method_10558(SHOW_DIMENSION_TAG);
                class_2338 blockPos = class_2512.method_10691(showTag.method_10562(SHOW_POS_TAG));
                return Pair.of(dimension, blockPos);
            }
        }
        return null;
    }

    @Override
    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 target, class_1268 usedHand) {
        if (usedHand == class_1268.field_5808 && target instanceof EntityMaid maid && maid.method_6171(player)) {
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT)
                openServantBellSetScreen(maid);
            return class_1269.field_5812;
        }
        return super.method_7847(stack, player, target, usedHand);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        class_1799 stack = playerIn.method_5998(handIn);
        UUID searchUuid = getMaidUuid(stack);
        if (searchUuid != null) {
            playerIn.method_6019(handIn);
            return class_1271.method_22428(stack);
        }
        if (!worldIn.field_9236) {
            playerIn.method_43496(class_2561.method_43471("message.touhou_little_maid.servant_bell.data_is_empty"));
        }
        return super.method_7836(worldIn, playerIn, handIn);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 worldIn, class_1309 entityLiving, int timeLeft) {
        if (!(entityLiving instanceof class_1657 player) || timeLeft < MIN_USE_DURATION) {
            return;
        }
        UUID searchUuid = getMaidUuid(stack);
        if (searchUuid == null) {
            player.method_43496(class_2561.method_43471("message.touhou_little_maid.servant_bell.data_is_empty"));
            return;
        }
        if (worldIn instanceof class_3218 serverLevel) {
            List<? extends EntityMaid> maids = serverLevel.method_18198(EntityMaid.TYPE, maid -> checkMaidUuid(player, maid, searchUuid));
            if (maids.isEmpty()) {
                showMaidInfo(worldIn, player, stack, searchUuid);
            } else {
                stack.method_7948().method_10551(SHOW_TAG);
                teleportMaid(player, maids);
            }
        }
        worldIn.method_8396(null, player.method_24515(), class_3417.field_17265, class_3419.field_15245, 2.0F, 1.0F);
        if (player instanceof class_3222 serverPlayer) {
            InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.USE_SERVANT_BELL);
        }
        player.method_7357().method_7906(this, 20);
    }

    @Nullable
    private UUID getMaidUuid(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_25928(UUID_TAG)) {
            return tag.method_25926(UUID_TAG);
        }
        return null;
    }

    private void teleportMaid(class_1657 player, List<? extends EntityMaid> maids) {
        maids.forEach(maid -> {
            maid.setHomeModeEnable(false);
            maid.method_6092(new class_1293(class_1294.field_5912, 200, 1, true, false));
            maid.method_5859(player.method_23317() + player.method_6051().method_43048(3) - 1, player.method_23318(), player.method_23321() + player.method_6051().method_43048(3) - 1);
        });
    }

    private void showMaidInfo(class_1937 worldIn, class_1657 player, class_1799 stack, UUID searchUuid) {
        MaidWorldData data = MaidWorldData.get(worldIn);
        if (data == null) {
            player.method_43496(class_2561.method_43471("message.touhou_little_maid.servant_bell.no_result"));
            return;
        }
        List<MaidInfo> infos = data.getPlayerMaidInfos(player);
        if (infos == null || infos.isEmpty()) {
            player.method_43496(class_2561.method_43471("message.touhou_little_maid.servant_bell.no_result"));
            return;
        }
        infos.stream().filter(info -> info.getEntityId().equals(searchUuid)).findFirst().ifPresentOrElse(info -> {
            String dimension = info.getDimension();
            String playerDimension = player.field_6002.method_27983().method_29177().toString();
            class_2487 showTag = stack.method_7911(SHOW_TAG);
            showTag.method_10582(SHOW_DIMENSION_TAG, dimension);
            showTag.method_10566(SHOW_POS_TAG, class_2512.method_10692(info.getChunkPos()));
            if (dimension.equals(playerDimension)) {
                player.method_43496(class_2561.method_43471("message.touhou_little_maid.servant_bell.show_pos"));
            } else {
                player.method_43496(class_2561.method_43469("message.touhou_little_maid.servant_bell.not_same_dimension", dimension));
            }
        }, () -> {
            player.method_43496(class_2561.method_43471("message.touhou_little_maid.servant_bell.no_result"));
        });
    }

    private boolean checkMaidUuid(class_1657 player, EntityMaid maid, UUID searchUuid) {
        return maid.method_6171(player) && maid.method_5667().equals(searchUuid);
    }

    @Environment(EnvType.CLIENT)
    private void openServantBellSetScreen(EntityMaid maid) {
        if (maid.field_6002.field_9236) {
            class_310.method_1551().method_1507(new ServantBellSetScreen(maid));
        }
    }

    @Override
    public int method_7881(class_1799 stack) {
        return 100;
    }

    @Override
    public class_1839 method_7853(class_1799 pStack) {
        return class_1839.field_8949;
    }

    @Override
    public class_2561 method_7864(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573(TIP_TAG, class_2520.field_33258)) {
            String tip = tag.method_10558(TIP_TAG);
            return class_2561.method_43470(tip).method_27692(class_124.field_1065).method_27692(class_124.field_1073);
        }
        return super.method_7864(stack);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        UUID uuid = getMaidUuid(stack);
        if (uuid != null) {
            tooltip.add(class_2561.method_43469("tooltips.touhou_little_maid.servant_bell.uuid", uuid.toString()).method_27692(class_124.field_1080));
            tooltip.add(class_5244.method_48320());
        }
        tooltip.add(class_2561.method_43471("tooltips.touhou_little_maid.servant_bell.desc.1").method_27692(class_124.field_1080));
        tooltip.add(class_2561.method_43471("tooltips.touhou_little_maid.servant_bell.desc.2").method_27692(class_124.field_1080));
    }
}
