package com.github.tartaricacid.touhoulittlemaid.world.data;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MaidWorldData extends class_18 {
    private static final String IDENTIFIER = "touhou_little_maid_world_data";
    private static final String MAID_INFOS_TAG = "MaidInfos";
    private static final String MAID_TOMBSTONES_TAG = "MaidTombstones";
    private final Map<UUID, List<MaidInfo>> infos = Maps.newHashMap();
    private final Map<UUID, List<MaidInfo>> tombstones = Maps.newHashMap();

    @Nullable
    public static MaidWorldData get(class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 overWorld = level.method_8503().method_3847(class_1937.field_25179);
            if (overWorld == null) {
                return null;
            }
            class_26 storage = overWorld.method_17983();
            MaidWorldData data = storage.method_17924(MaidWorldData::load, MaidWorldData::new, IDENTIFIER);
            data.method_80();
            return data;
        }
        return null;
    }

    public static MaidWorldData load(class_2487 tag) {
        MaidWorldData data = new MaidWorldData();
        if (tag.method_10573(MAID_INFOS_TAG, class_2520.field_33260)) {
            class_2487 infosTag = tag.method_10562(MAID_INFOS_TAG);
            for (String key : infosTag.method_10541()) {
                class_2499 listTag = infosTag.method_10554(key, class_2520.field_33260);
                for (int i = 0; i < listTag.size(); i++) {
                    class_2487 infoTag = listTag.method_10602(i);
                    String dimension = infoTag.method_10558("Dimension");
                    class_2338 chunkPos = class_2512.method_10691(infoTag.method_10562("ChunkPos"));
                    UUID ownerId = infoTag.method_25926("OwnerId");
                    UUID maidId = infoTag.method_25926("MaidId");
                    long timestamp = infoTag.method_10537("Timestamp");
                    class_5250 name = class_2561.class_2562.method_10877(infoTag.method_10558("Name"));
                    List<MaidInfo> maidInfos = data.infos.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
                    maidInfos.add(new MaidInfo(dimension, chunkPos, ownerId, maidId, timestamp, name));
                }
            }
        }
        if (tag.method_10573(MAID_TOMBSTONES_TAG, class_2520.field_33260)) {
            class_2487 tombstonesTag = tag.method_10562(MAID_TOMBSTONES_TAG);
            for (String key : tombstonesTag.method_10541()) {
                class_2499 listTag = tombstonesTag.method_10554(key, class_2520.field_33260);
                for (int i = 0; i < listTag.size(); i++) {
                    class_2487 infoTag = listTag.method_10602(i);
                    String dimension = infoTag.method_10558("Dimension");
                    class_2338 chunkPos = class_2512.method_10691(infoTag.method_10562("ChunkPos"));
                    UUID ownerId = infoTag.method_25926("OwnerId");
                    UUID tombstoneId = infoTag.method_25926("TombstoneId");
                    long timestamp = infoTag.method_10537("Timestamp");
                    class_5250 name = class_2561.class_2562.method_10877(infoTag.method_10558("Name"));
                    List<MaidInfo> tombstoneInfos = data.tombstones.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
                    tombstoneInfos.add(new MaidInfo(dimension, chunkPos, ownerId, tombstoneId, timestamp, name));
                }
            }
        }
        return data;
    }

    @Override
    public class_2487 method_75(class_2487 tag) {
        class_2487 infosTag = new class_2487();
        infos.forEach((id, data) -> {
            class_2499 listTag = new class_2499();
            data.forEach(info -> {
                class_2487 infoTag = new class_2487();
                infoTag.method_10582("Dimension", info.getDimension());
                infoTag.method_10566("ChunkPos", class_2512.method_10692(info.getChunkPos()));
                infoTag.method_25927("OwnerId", info.getOwnerId());
                infoTag.method_25927("MaidId", info.getEntityId());
                infoTag.method_10544("Timestamp", info.getTimestamp());
                infoTag.method_10582("Name", class_2561.class_2562.method_10867(info.getName()));
                listTag.add(infoTag);
            });
            infosTag.method_10566(id.toString(), listTag);
        });

        class_2487 tombstonesTag = new class_2487();
        tombstones.forEach((id, data) -> {
            class_2499 listTag = new class_2499();
            data.forEach(info -> {
                class_2487 infoTag = new class_2487();
                infoTag.method_10582("Dimension", info.getDimension());
                infoTag.method_10566("ChunkPos", class_2512.method_10692(info.getChunkPos()));
                infoTag.method_25927("OwnerId", info.getOwnerId());
                infoTag.method_25927("TombstoneId", info.getEntityId());
                infoTag.method_10544("Timestamp", info.getTimestamp());
                infoTag.method_10582("Name", class_2561.class_2562.method_10867(info.getName()));
                listTag.add(infoTag);
            });
            tombstonesTag.method_10566(id.toString(), listTag);
        });
        tag.method_10566(MAID_INFOS_TAG, infosTag);
        tag.method_10566(MAID_TOMBSTONES_TAG, tombstonesTag);
        return tag;
    }

    public void addInfo(MaidInfo info) {
        UUID ownerId = info.getOwnerId();
        List<MaidInfo> maidInfos = this.infos.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
        maidInfos.add(info);
        this.method_80();
    }

    public void addInfo(EntityMaid maid) {
        String dimension = maid.field_6002.method_27983().method_29177().toString();
        class_2338 chunkPos = maid.method_24515();
        UUID ownerId = maid.method_6139();
        UUID maidId = maid.method_5667();
        long timestamp = System.currentTimeMillis();
        class_2561 name = maid.method_5476();
        this.addInfo(new MaidInfo(dimension, chunkPos, ownerId, maidId, timestamp, name));
    }

    public void removeInfo(EntityMaid maid) {
        UUID ownerId = maid.method_6139();
        if (this.infos.containsKey(ownerId)) {
            UUID maidId = maid.method_5667();
            this.infos.get(ownerId).removeIf(info -> info.getEntityId().equals(maidId));
            this.method_80();
        }
    }

    @Nullable
    public List<MaidInfo> getInfos(UUID owner) {
        return infos.get(owner);
    }

    @Nullable
    public List<MaidInfo> getPlayerMaidInfos(class_1657 player) {
        return this.infos.get(player.method_5667());
    }

    public void addTombstones(MaidInfo info) {
        UUID ownerId = info.getOwnerId();
        List<MaidInfo> tombstoneInfos = this.tombstones.computeIfAbsent(ownerId, uuid -> Lists.newArrayList());
        tombstoneInfos.add(info);
        this.method_80();
    }

    public void addTombstones(EntityMaid maid, EntityTombstone tombstone) {
        String dimension = maid.field_6002.method_27983().method_29177().toString();
        class_2338 chunkPos = tombstone.method_24515();
        UUID ownerId = maid.method_6139();
        UUID tombstoneId = tombstone.method_5667();
        long timestamp = System.currentTimeMillis();
        class_2561 name = maid.method_5476();
        this.addTombstones(new MaidInfo(dimension, chunkPos, ownerId, tombstoneId, timestamp, name));
    }

    public void removeTombstones(EntityTombstone tombstone) {
        UUID ownerId = tombstone.getOwnerId();
        if (this.tombstones.containsKey(ownerId)) {
            UUID tombstoneId = tombstone.method_5667();
            this.tombstones.get(ownerId).removeIf(info -> info.getEntityId().equals(tombstoneId));
            this.method_80();
        }
    }

    @Nullable
    public List<MaidInfo> getTombstones(UUID owner) {
        return tombstones.get(owner);
    }

    @Nullable
    public List<MaidInfo> getPlayerMaidTombstones(class_1657 player) {
        return this.tombstones.get(player.method_5667());
    }
}