/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.tts.player2;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ErrorCode;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ServiceType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSystemServices;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.player2.TTSPlayer2Request;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.player2.TTSPlayer2Site;
import com.google.common.net.MediaType;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public class TTSPlayer2Client
implements TTSClient,
TTSSystemServices {
    private static final Duration MAX_TIMEOUT = Duration.ofSeconds(20L);
    private final HttpClient httpClient;
    private final TTSPlayer2Site site;

    public TTSPlayer2Client(HttpClient httpClient, TTSPlayer2Site site) {
        this.httpClient = httpClient;
        this.site = site;
    }

    @Override
    public void play(String message, TTSConfig config, @Nullable ResponseCallback<byte[]> callback) {
        if (this.isClient()) {
            this.handle(message, config);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void handle(String message, TTSConfig config) {
        URI url = URI.create(this.site.url());
        String model = config.model();
        TTSPlayer2Request request = TTSPlayer2Request.create().setText(message).setVoiceId(model);
        HttpRequest.Builder builder = HttpRequest.newBuilder().header("Content-Type", MediaType.JSON_UTF_8.toString()).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)request))).timeout(MAX_TIMEOUT).uri(url);
        this.site.headers().forEach(builder::header);
        HttpRequest httpRequest = builder.build();
        this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofByteArray()).whenComplete((response, throwable) -> {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            if (throwable != null) {
                String cause = throwable.getLocalizedMessage();
                class_5250 errorMessage = ErrorCode.getErrorMessage(ServiceType.TTS, 0, cause);
                player.method_43496((class_2561)errorMessage.method_27692(class_124.field_1061));
                TouhouLittleMaid.LOGGER.error("TTS request failed: {}, error is {}", (Object)request, (Object)throwable.getMessage());
            }
            if (!this.isSuccessful((HttpResponse<?>)response)) {
                String string = new String((byte[])response.body(), StandardCharsets.UTF_8);
                String cause = String.format("HTTP Error Code: %d, Response %s", response.statusCode(), string);
                class_5250 errorMessage = ErrorCode.getErrorMessage(ServiceType.TTS, 1, cause);
                player.method_43496((class_2561)errorMessage.method_27692(class_124.field_1061));
                TouhouLittleMaid.LOGGER.error("TTS request failed: {}, error is {}", (Object)request, (Object)cause);
            }
        });
    }
}

