/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.inner;

import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.IAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.InnerAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.ibm.icu.util.ChineseCalendar;
import com.ibm.icu.util.ULocale;
import java.util.Calendar;
import java.util.HashMap;
import net.minecraft.class_1309;
import net.minecraft.class_2960;

public final class FestivalAnimation {
    private static final ULocale CHINESE = new ULocale("@calendar=chinese");

    public static void init() {
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/base/festival/new_year.js"), FestivalAnimation.getNewYear());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/base/festival/christmas.js"), FestivalAnimation.getChristmas());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/base/festival/spring_festival.js"), FestivalAnimation.getSpringFestival());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/base/festival/duanwu.js"), FestivalAnimation.getDuanwu());
        InnerAnimation.INNER_ANIMATION.put(new class_2960("touhou_little_maid:animation/base/festival/mid_autumn.js"), FestivalAnimation.getMidAutumn());
    }

    public static IAnimation<class_1309> getNewYear() {
        return new IAnimation<class_1309>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netLeadYaw, float headPitch, float scaleFactor, class_1309 entity, HashMap<String, ModelRendererWrapper> modelMap) {
                boolean isNewYear;
                ModelRendererWrapper newYearShow = modelMap.get("newYearShow");
                ModelRendererWrapper newYearHidden = modelMap.get("newYearHidden");
                Calendar calendar = Calendar.getInstance();
                int month = calendar.get(2);
                int dayInMonth = calendar.get(5);
                boolean bl = isNewYear = month == 0 && dayInMonth == 1;
                if (newYearShow != null) {
                    newYearShow.setHidden(!isNewYear);
                }
                if (newYearHidden != null) {
                    newYearHidden.setHidden(isNewYear);
                }
            }
        };
    }

    public static IAnimation<class_1309> getChristmas() {
        return new IAnimation<class_1309>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netLeadYaw, float headPitch, float scaleFactor, class_1309 entity, HashMap<String, ModelRendererWrapper> modelMap) {
                boolean isChristmas;
                ModelRendererWrapper christmasShow = modelMap.get("christmasShow");
                ModelRendererWrapper christmasHidden = modelMap.get("christmasHidden");
                Calendar calendar = Calendar.getInstance();
                int month = calendar.get(2);
                int dayInMonth = calendar.get(5);
                boolean bl = isChristmas = month == 11 && (dayInMonth == 24 || dayInMonth == 25);
                if (christmasShow != null) {
                    christmasShow.setHidden(!isChristmas);
                }
                if (christmasHidden != null) {
                    christmasHidden.setHidden(isChristmas);
                }
            }
        };
    }

    public static IAnimation<class_1309> getSpringFestival() {
        return new IAnimation<class_1309>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netLeadYaw, float headPitch, float scaleFactor, class_1309 entity, HashMap<String, ModelRendererWrapper> modelMap) {
                boolean isSpringFestival;
                ModelRendererWrapper springFestivalShow = modelMap.get("springFestivalShow");
                ModelRendererWrapper springFestivalHidden = modelMap.get("springFestivalHidden");
                com.ibm.icu.util.Calendar calendar = ChineseCalendar.getInstance((ULocale)CHINESE);
                int month = calendar.get(2);
                int dayInMonth = calendar.get(5);
                boolean bl = isSpringFestival = month == 11 && dayInMonth >= 29 || month == 0 && dayInMonth <= 6;
                if (springFestivalShow != null) {
                    springFestivalShow.setHidden(!isSpringFestival);
                }
                if (springFestivalHidden != null) {
                    springFestivalHidden.setHidden(isSpringFestival);
                }
            }
        };
    }

    public static IAnimation<class_1309> getDuanwu() {
        return new IAnimation<class_1309>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netLeadYaw, float headPitch, float scaleFactor, class_1309 entity, HashMap<String, ModelRendererWrapper> modelMap) {
                boolean isDuanwu;
                ModelRendererWrapper duanwuShow = modelMap.get("duanwuShow");
                ModelRendererWrapper duanwuHidden = modelMap.get("duanwuHidden");
                com.ibm.icu.util.Calendar calendar = ChineseCalendar.getInstance((ULocale)CHINESE);
                int month = calendar.get(2);
                int dayInMonth = calendar.get(5);
                boolean bl = isDuanwu = month == 4 && dayInMonth == 5;
                if (duanwuShow != null) {
                    duanwuShow.setHidden(!isDuanwu);
                }
                if (duanwuHidden != null) {
                    duanwuHidden.setHidden(isDuanwu);
                }
            }
        };
    }

    public static IAnimation<class_1309> getMidAutumn() {
        return new IAnimation<class_1309>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netLeadYaw, float headPitch, float scaleFactor, class_1309 entity, HashMap<String, ModelRendererWrapper> modelMap) {
                boolean isMidAutumn;
                ModelRendererWrapper midAutumnShow = modelMap.get("midAutumnShow");
                ModelRendererWrapper midAutumnHidden = modelMap.get("midAutumnHidden");
                com.ibm.icu.util.Calendar calendar = ChineseCalendar.getInstance((ULocale)CHINESE);
                int month = calendar.get(2);
                int dayInMonth = calendar.get(5);
                boolean bl = isMidAutumn = month == 7 && dayInMonth == 15;
                if (midAutumnShow != null) {
                    midAutumnShow.setHidden(!isMidAutumn);
                }
                if (midAutumnHidden != null) {
                    midAutumnHidden.setHidden(isMidAutumn);
                }
            }
        };
    }
}

