/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.script;

import com.github.tartaricacid.touhoulittlemaid.api.animation.IMaidData;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.WorldWrapper;
import com.github.tartaricacid.touhoulittlemaid.util.BiomeCacheUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_7923;

public final class EntityMaidWrapper
implements IMaidData {
    private final WorldWrapper world = new WorldWrapper();
    private final float[] handRotation = new float[]{0.0f, 0.0f, 0.0f};
    private float swingProgress;
    private boolean isRiding;
    private IMaid maid;

    public void setData(IMaid maid, float swingProgress, boolean isRiding) {
        this.maid = maid;
        this.swingProgress = swingProgress;
        this.isRiding = isRiding;
        this.world.setData(maid.asEntity().method_37908());
    }

    public void clearData() {
        this.maid = null;
        this.world.clearData();
    }

    @Override
    public WorldWrapper getWorld() {
        return this.world;
    }

    @Override
    public String getTask() {
        return this.maid.getTask().getUid().toString();
    }

    @Override
    public boolean hasHelmet() {
        return this.maid.hasHelmet();
    }

    @Override
    public String getHelmet() {
        class_2960 res = class_7923.field_41178.method_10221((Object)this.maid.asEntity().method_6118(class_1304.field_6169).method_7909());
        if (res != class_7923.field_41178.method_10137()) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasChestPlate() {
        return this.maid.hasChestPlate();
    }

    @Override
    public String getChestPlate() {
        class_2960 res = class_7923.field_41178.method_10221((Object)this.maid.asEntity().method_6118(class_1304.field_6174).method_7909());
        if (res != class_7923.field_41178.method_10137()) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasLeggings() {
        return this.maid.hasLeggings();
    }

    @Override
    public String getLeggings() {
        class_2960 res = class_7923.field_41178.method_10221((Object)this.maid.asEntity().method_6118(class_1304.field_6172).method_7909());
        if (res != class_7923.field_41178.method_10137()) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasBoots() {
        return this.maid.hasBoots();
    }

    @Override
    public String getBoots() {
        class_2960 res = class_7923.field_41178.method_10221((Object)this.maid.asEntity().method_6118(class_1304.field_6166).method_7909());
        if (res != class_7923.field_41178.method_10137()) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasItemMainhand() {
        return this.maid.asEntity().method_6047().method_7960();
    }

    @Override
    public String getItemMainhand() {
        class_2960 res = class_7923.field_41178.method_10221((Object)this.maid.asEntity().method_6047().method_7909());
        if (res != class_7923.field_41178.method_10137()) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasItemOffhand() {
        return this.maid.asEntity().method_6079().method_7960();
    }

    @Override
    public String getItemOffhand() {
        class_2960 res = class_7923.field_41178.method_10221((Object)this.maid.asEntity().method_6079().method_7909());
        if (res != class_7923.field_41178.method_10137()) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean isBegging() {
        return this.maid.isBegging();
    }

    @Override
    public boolean isSwingingArms() {
        return this.maid.isSwingingArms();
    }

    @Override
    public boolean isRiding() {
        return this.isRiding;
    }

    @Override
    public boolean isSitting() {
        return this.maid.isMaidInSittingPose();
    }

    @Override
    public boolean hasBackpack() {
        return this.maid.hasBackpack();
    }

    @Override
    @Deprecated
    public int getBackpackLevel() {
        return 0;
    }

    @Override
    public boolean inWater() {
        return this.maid.asEntity().method_5799();
    }

    @Override
    public boolean inRain() {
        return this.maid.asEntity().method_37908().method_8520(this.maid.asEntity().method_24515());
    }

    @Override
    public boolean isSwingLeftHand() {
        return this.maid.asEntity().field_6266 == class_1268.field_5810;
    }

    @Override
    public float getSwingProgress() {
        return this.swingProgress;
    }

    @Override
    public float getHealth() {
        return this.maid.asEntity().method_6032();
    }

    @Override
    public float getMaxHealth() {
        return this.maid.asEntity().method_6063();
    }

    @Override
    public double getArmorValue() {
        return this.maid.asEntity().method_26825(class_5134.field_23724);
    }

    @Override
    public boolean onHurt() {
        return this.maid.asEntity().field_6235 > 0;
    }

    @Override
    public boolean isSleep() {
        return this.maid.asEntity().method_6113();
    }

    @Override
    public int getFavorability() {
        return this.maid.getFavorability();
    }

    @Override
    public long getSeed() {
        return Math.abs(this.maid.asEntity().method_5667().getLeastSignificantBits());
    }

    @Override
    public class_1959 getAtBiome() {
        return BiomeCacheUtil.getCacheBiome((class_1297)this.maid.asEntity());
    }

    @Override
    public boolean isOnGround() {
        return !this.maid.asEntity().method_24828();
    }

    @Override
    @Deprecated
    public String getAtBiomeTemp() {
        return this.maid.getAtBiomeTemp();
    }

    @Override
    @Deprecated
    public boolean hasSasimono() {
        return false;
    }

    @Override
    @Deprecated
    public boolean isHoldTrolley() {
        return false;
    }

    @Override
    @Deprecated
    public boolean isRidingMarisaBroom() {
        return false;
    }

    @Override
    public boolean isRidingPlayer() {
        return this.maid.asEntity().method_5854() instanceof class_1657;
    }

    @Override
    @Deprecated
    public boolean isHoldVehicle() {
        return false;
    }

    @Override
    @Deprecated
    public boolean isPortableAudioPlay() {
        return false;
    }

    @Override
    @Deprecated
    public float[] getLeftHandRotation() {
        return this.handRotation;
    }

    @Override
    @Deprecated
    public float[] getRightHandRotation() {
        return this.handRotation;
    }

    @Override
    @Deprecated
    public int getDim() {
        return this.maid.getDim();
    }
}

