/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.client.render.MaidRenderState;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.item.ItemGarageKit;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_638;
import net.minecraft.class_756;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_824;
import net.minecraft.class_898;

public class TileEntityItemStackGarageKitRenderer
extends class_756 {
    private static final class_2960 TEXTURE = new class_2960("touhou_little_maid", "textures/bedrock/block/statue_base.png");
    private static SimpleBedrockModel<class_1297> BASE_MODEL;
    public static final Supplier<TileEntityItemStackGarageKitRenderer> INSTANCE;

    public TileEntityItemStackGarageKitRenderer(class_824 dispatcher, class_5599 modelSet) {
        super(dispatcher, modelSet);
        BASE_MODEL = BedrockModelLoader.getModel(BedrockModelLoader.STATUE_BASE);
    }

    public void method_3166(class_1799 stack, class_811 transformType, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (BASE_MODEL == null) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        poseStack.method_22904(1.0, 1.5, 1.0);
        poseStack.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
        class_4588 buffer = bufferIn.getBuffer(class_1921.method_23578((class_2960)TEXTURE));
        BASE_MODEL.method_2828(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.method_22909();
        class_2487 data = ItemGarageKit.getMaidData(stack);
        class_638 world = class_310.method_1551().field_1687;
        if (data.method_33133() || world == null) {
            return;
        }
        class_1299.method_5898((String)data.method_10558("id")).ifPresent(arg_0 -> this.lambda$renderByItem$1(stack, poseStack, bufferIn, combinedLightIn, data, (class_1937)world, arg_0));
    }

    private void renderEntity(class_1799 stack, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, class_2487 data, class_1937 world, class_1299<?> type) throws ExecutionException {
        class_1297 entity = type.equals(InitEntities.MAID) ? (class_1297)EntityCacheUtil.GARAGE_KIT_CACHE.get((Object)stack, () -> new EntityMaid(world)) : (class_1297)EntityCacheUtil.ENTITY_CACHE.get(type, () -> {
            class_1297 e = type.method_5883(world);
            return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
        });
        float renderItemScale = 1.0f;
        entity.method_5651(data);
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            EntityCacheUtil.clearMaidDataResidue(maid, true);
            if (data.method_10573("ModelId", 8)) {
                String modelId = data.method_10558("ModelId");
                renderItemScale = CustomPackLoader.MAID_MODELS.getModelRenderItemScale(modelId);
            }
            maid.renderState = MaidRenderState.GARAGE_KIT;
        }
        poseStack.method_22903();
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        poseStack.method_22905(renderItemScale, renderItemScale, renderItemScale);
        poseStack.method_22904(1.0, 0.21328125, 1.0);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        class_898 render = class_310.method_1551().method_1561();
        boolean isShowHitBox = render.method_3958();
        render.method_3955(false);
        RenderSystem.runAsFancy(() -> render.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, bufferIn, combinedLightIn));
        render.method_3955(isShowHitBox);
        poseStack.method_22909();
    }

    private /* synthetic */ void lambda$renderByItem$1(class_1799 stack, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, class_2487 data, class_1937 world, class_1299 type) {
        try {
            this.renderEntity(stack, poseStack, bufferIn, combinedLightIn, data, world, type);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    static {
        INSTANCE = Suppliers.memoize(() -> {
            class_310 minecraft = class_310.method_1551();
            return new TileEntityItemStackGarageKitRenderer(minecraft.method_31975(), minecraft.method_31974());
        });
    }
}

