/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource.listener;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_4013;

public class EmojiReloadListener
implements class_4013,
IdentifiableResourceReloadListener {
    private static final List<EmojiResource> EMOJI_RESOURCES = Lists.newArrayList();
    private static final String EMOJI_PATH = "textures/chat_bubble/maid_emoji";
    private static final Random RANDOM = new Random();
    private static final int MIN_SIZE = 8;
    private static final int MAX_SIZE = 256;
    private static final class_2960 ID = new class_2960("touhou_little_maid", "emoji_reload");

    public void method_14491(class_3300 resourceManager) {
        Set paths = resourceManager.method_14488(EMOJI_PATH, EmojiReloadListener::filterEmojiResource).keySet();
        EMOJI_RESOURCES.clear();
        paths.forEach(res -> EMOJI_RESOURCES.add(EmojiResource.parse(res)));
    }

    public static boolean filterEmojiResource(class_2960 res) {
        String path = res.method_12832();
        return path.endsWith(".png") || path.endsWith(".gif");
    }

    public static Optional<EmojiResource> getRandomEmojis() {
        if (EMOJI_RESOURCES.isEmpty()) {
            return Optional.empty();
        }
        int index = RANDOM.nextInt(EMOJI_RESOURCES.size());
        return Optional.ofNullable(EMOJI_RESOURCES.get(index));
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public record EmojiResource(class_2960 location, Format format, int width, int height) {
        private static final Pattern SIZE_PATTERN = Pattern.compile("^.*?-(\\d+)x(\\d+)\\.(png|gif)$");

        public static EmojiResource parse(class_2960 res) {
            Format format;
            String path = res.method_12832();
            Matcher matcher = SIZE_PATTERN.matcher(path);
            Format format2 = format = path.endsWith(".gif") ? Format.GIF : Format.PNG;
            if (matcher.matches()) {
                int width = Integer.parseInt(matcher.group(1));
                int height = Integer.parseInt(matcher.group(2));
                width = class_3532.method_15340((int)width, (int)8, (int)256);
                height = class_3532.method_15340((int)height, (int)8, (int)256);
                return new EmojiResource(res, format, width, height);
            }
            return new EmojiResource(res, format, 24, 24);
        }

        public boolean isGif() {
            return this.format == Format.GIF;
        }
    }

    static enum Format {
        PNG,
        GIF;

    }
}

