/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.tooltip;

import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.GomokuCodec;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.BoardStateTooltip;
import com.github.tartaricacid.touhoulittlemaid.util.CChessUtil;
import com.github.tartaricacid.touhoulittlemaid.util.WChessUtil;
import java.util.function.BiFunction;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;

public class ClientBoardStateTooltip
implements class_5684 {
    private static final class_2960 GOMOKU_BG = new class_2960("touhou_little_maid", "textures/gui/gomoku.png");
    private static final class_2960 XIANGQI_BG = new class_2960("touhou_little_maid", "textures/gui/xiangqi.png");
    private static final class_2960 CHESS_BG = new class_2960("touhou_little_maid", "textures/gui/chess.png");
    private static final BiFunction<String, String, Object> CACHE = class_156.method_34865(ClientBoardStateTooltip::getBoardGameData);
    private final String type;
    private final Object boardGameData;

    public ClientBoardStateTooltip(BoardStateTooltip tooltip) {
        this.boardGameData = CACHE.apply(tooltip.type(), tooltip.stateData());
        this.type = tooltip.type();
    }

    @Nullable
    private static Cloneable getBoardGameData(String type, String stateData) {
        switch (type) {
            case "gomoku": {
                return GomokuCodec.decode(stateData).board();
            }
            case "xiangqi": {
                com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Position position = new com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Position();
                position.fromFen(stateData);
                return position.squares;
            }
            case "chess": {
                Position position = new Position();
                position.fromFen(stateData);
                return position.squares;
            }
        }
        return null;
    }

    public int method_32661() {
        if (this.boardGameData == null) {
            return 0;
        }
        return switch (this.type) {
            case "gomoku" -> 80;
            case "xiangqi" -> 132;
            case "chess" -> 108;
            default -> 0;
        };
    }

    public int method_32664(class_327 font) {
        if (this.boardGameData == null) {
            return 0;
        }
        return switch (this.type) {
            case "gomoku" -> 76;
            case "xiangqi" -> 128;
            case "chess" -> 102;
            default -> 0;
        };
    }

    public void method_32666(class_327 font, int pX, int pY, class_332 graphics) {
        Object object;
        if (this.boardGameData == null) {
            return;
        }
        if (this.type.equals("gomoku") && (object = this.boardGameData) instanceof int[][]) {
            int[][] data = (int[][])object;
            this.renderGomoku(pX, pY, graphics, data);
            return;
        }
        if (this.type.equals("xiangqi") && (object = this.boardGameData) instanceof byte[]) {
            byte[] data = (byte[])object;
            this.renderXiangqi(pX, pY, graphics, data);
            return;
        }
        if (this.type.equals("chess") && (object = this.boardGameData) instanceof byte[]) {
            byte[] chessData = (byte[])object;
            this.renderChess(pX, pY, graphics, chessData);
        }
    }

    private void renderGomoku(int pX, int pY, class_332 graphics, int[][] data) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(0.5f, 0.5f, 1.0f);
        graphics.method_51448().method_46416((float)pX, (float)pY, 0.0f);
        graphics.method_25302(GOMOKU_BG, pX, pY, 0, 0, 151, 151);
        for (int y = 0; y <= 14; ++y) {
            for (int x = 0; x <= 14; ++x) {
                int v;
                int piecesIndex = data[x][y];
                if (piecesIndex == 1) {
                    v = 151;
                } else {
                    if (piecesIndex != 2) continue;
                    v = 160;
                }
                int offsetX = pX + 1 + x * 10;
                int offsetY = pY + 1 + y * 10;
                graphics.method_25302(GOMOKU_BG, offsetX, offsetY, 0, v, 9, 9);
            }
        }
        graphics.method_51448().method_22909();
    }

    private void renderXiangqi(int pX, int pY, class_332 graphics, byte[] data) {
        graphics.method_25302(XIANGQI_BG, pX, pY, 0, 0, 128, 126);
        for (int y = 3; y <= 12; ++y) {
            for (int x = 3; x <= 11; ++x) {
                int u;
                int v;
                byte piecesIndex = CChessUtil.piecesIndex(x, y, data);
                if (CChessUtil.isRed(piecesIndex)) {
                    v = 126;
                    u = (piecesIndex - 8) * 11;
                } else {
                    if (!CChessUtil.isBlack(piecesIndex)) continue;
                    v = 137;
                    u = (piecesIndex - 16) * 11;
                }
                int offsetX = pX - 1 + (x - 3) * 13;
                int offsetY = pY - 1 + (y - 3) * 13;
                graphics.method_25302(XIANGQI_BG, offsetX, offsetY, u, v, 11, 11);
            }
        }
    }

    private void renderChess(int pX, int pY, class_332 graphics, byte[] data) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(0.5f, 0.5f, 1.0f);
        graphics.method_51448().method_46416((float)pX, (float)pY, 0.0f);
        graphics.method_25302(CHESS_BG, pX, pY, 0, 0, 204, 204);
        for (int y = 0; y <= 7; ++y) {
            for (int x = 4; x <= 11; ++x) {
                int u;
                int v;
                byte piecesIndex = WChessUtil.piecesIndex(x, y, data);
                if (WChessUtil.isWhite(piecesIndex)) {
                    v = 204;
                    u = (piecesIndex - 8) * 24;
                } else {
                    if (!WChessUtil.isBlack(piecesIndex)) continue;
                    v = 228;
                    u = (piecesIndex - 16) * 24;
                }
                int offsetX = pX + 6 + (x - 4) * 24;
                int offsetY = pY + 6 + y * 24;
                graphics.method_25302(CHESS_BG, offsetX, offsetY, u, v, 24, 24);
            }
        }
        graphics.method_51448().method_22909();
    }
}

