/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.command.arguments.HandleTypeArgument;
import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncDataMessage;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public final class PowerCommand {
    private static final String POWER_NAME = "power";
    private static final String GET_NAME = "get";
    private static final String HANDLE_NAME = "handle";
    private static final String TARGETS_NAME = "targets";
    private static final String COUNT_NAME = "count";

    public static LiteralArgumentBuilder<class_2168> get() {
        LiteralArgumentBuilder pack = class_2170.method_9247((String)POWER_NAME);
        RequiredArgumentBuilder targets = class_2170.method_9244((String)TARGETS_NAME, (ArgumentType)class_2186.method_9308());
        RequiredArgumentBuilder count = class_2170.method_9244((String)COUNT_NAME, (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)5.0f));
        RequiredArgumentBuilder handleType = class_2170.method_9244((String)HANDLE_NAME, (ArgumentType)HandleTypeArgument.type());
        pack.then(class_2170.method_9247((String)GET_NAME).then(targets.executes(PowerCommand::getPower)));
        pack.then(handleType.then(targets.then(count.executes(PowerCommand::handlePower))));
        return pack;
    }

    private static int handlePower(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(context, (String)TARGETS_NAME);
        float count = FloatArgumentType.getFloat(context, (String)COUNT_NAME);
        String type = HandleTypeArgument.getType(context, HANDLE_NAME);
        for (class_3222 player : players) {
            PowerAttachment powerAttachment = (PowerAttachment)player.getAttachedOrCreate(InitDataAttachment.POWER_NUM, () -> new PowerAttachment(0.0f));
            MaidNumAttachment maidNumAttachment = (MaidNumAttachment)player.getAttachedOrCreate(InitDataAttachment.MAID_NUM, () -> new MaidNumAttachment(0));
            switch (type) {
                case "set": {
                    powerAttachment.set(count);
                    break;
                }
                case "add": {
                    powerAttachment.add(count);
                    break;
                }
                case "min": {
                    powerAttachment.min(count);
                    break;
                }
            }
            player.setAttached(InitDataAttachment.POWER_NUM, (Object)new PowerAttachment(powerAttachment.get()));
            ServerPlayNetworking.send((class_3222)player, (class_2960)SyncDataMessage.ID, (class_2540)SyncDataMessage.encode(powerAttachment.get(), maidNumAttachment.get()));
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.touhou_little_maid.power.handle.info", (Object[])new Object[]{players.size()}), true);
        return 1;
    }

    private static int getPower(CommandContext<class_2168> context) throws CommandSyntaxException {
        for (class_1657 player : class_2186.method_9312(context, (String)TARGETS_NAME)) {
            PowerAttachment power = (PowerAttachment)player.getAttachedOrCreate(InitDataAttachment.POWER_NUM, () -> new PowerAttachment(0.0f));
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.touhou_little_maid.power.get.info", (Object[])new Object[]{player.method_5820(), Float.valueOf(power.get())}), false);
        }
        return 1;
    }
}

